package com.autonavi.amapauto.protocol.model.client;

import com.autonavi.amapauto.protocol.constant.StandardProtocolKey;
import com.autonavi.amapauto.protocol.model.item.PowertrainLossInfo;
import com.autonavi.amapauto.protocol.model.item.PowertrainLossInfo_JsonLubeSerializer;
import java.io.Serializable;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/* loaded from: classes.dex */
public final class RspCarEnergyInfoModel_JsonLubeSerializer implements Serializable {
    public static JSONObject serialize(RspCarEnergyInfoModel rspCarEnergyInfoModel) throws JSONException {
        if (rspCarEnergyInfoModel == null) {
            return null;
        }
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("packageName", rspCarEnergyInfoModel.getPackageName());
        jSONObject.put("clientPackageName", rspCarEnergyInfoModel.getClientPackageName());
        jSONObject.put("callbackId", rspCarEnergyInfoModel.getCallbackId());
        jSONObject.put("timeStamp", rspCarEnergyInfoModel.getTimeStamp());
        jSONObject.put("var1", rspCarEnergyInfoModel.getVar1());
        jSONObject.put("auxCost", rspCarEnergyInfoModel.getAuxCost());
        jSONObject.put("curDriveMode", rspCarEnergyInfoModel.getCurDriveMode());
        if (rspCarEnergyInfoModel.getCurveCostlist() != null) {
            JSONArray jSONArray = new JSONArray();
            Iterator<Double> it = rspCarEnergyInfoModel.getCurveCostlist().iterator();
            while (it.hasNext()) {
                jSONArray.put(it.next());
            }
            jSONObject.put("curveCostlist", jSONArray);
        }
        jSONObject.put("energyUnit", rspCarEnergyInfoModel.getEnergyUnit());
        jSONObject.put("ferryrateCost", rspCarEnergyInfoModel.getFerryrateCost());
        jSONObject.put("initialHvBattenergy", rspCarEnergyInfoModel.getInitialHvBattenergy());
        jSONObject.put("isCharge", rspCarEnergyInfoModel.getIsCharge());
        jSONObject.put("lowEnergyAlert", rspCarEnergyInfoModel.getLowEnergyAlert());
        jSONObject.put("lowEnergyWarn", rspCarEnergyInfoModel.getLowEnergyWarn());
        jSONObject.put("maxBattEnergy", rspCarEnergyInfoModel.getMaxBattEnergy());
        jSONObject.put(StandardProtocolKey.EXTRA_PERCENT_OF_RESIDUAL_ENERGY, rspCarEnergyInfoModel.getPercentOfResidualEnergy());
        if (rspCarEnergyInfoModel.getPowertrainLoss() != null) {
            JSONArray jSONArray2 = new JSONArray();
            Iterator<PowertrainLossInfo> it2 = rspCarEnergyInfoModel.getPowertrainLoss().iterator();
            while (it2.hasNext()) {
                PowertrainLossInfo next = it2.next();
                if (next != null) {
                    jSONArray2.put(PowertrainLossInfo_JsonLubeSerializer.serialize(next));
                }
            }
            jSONObject.put("powertrainLoss", jSONArray2);
        }
        jSONObject.put("rangeDist", rspCarEnergyInfoModel.getRangeDist());
        if (rspCarEnergyInfoModel.getSlopeCostlist() != null) {
            JSONArray jSONArray3 = new JSONArray();
            Iterator<Double> it3 = rspCarEnergyInfoModel.getSlopeCostlist().iterator();
            while (it3.hasNext()) {
                jSONArray3.put(it3.next());
            }
            jSONObject.put("slopeCostlist", jSONArray3);
        }
        if (rspCarEnergyInfoModel.getSpeedCostlist() != null) {
            JSONArray jSONArray4 = new JSONArray();
            Iterator<Double> it4 = rspCarEnergyInfoModel.getSpeedCostlist().iterator();
            while (it4.hasNext()) {
                jSONArray4.put(it4.next());
            }
            jSONObject.put("speedCostlist", jSONArray4);
        }
        jSONObject.put("topSpeed", rspCarEnergyInfoModel.getTopSpeed());
        if (rspCarEnergyInfoModel.getTransCostlist() != null) {
            JSONArray jSONArray5 = new JSONArray();
            Iterator<Double> it5 = rspCarEnergyInfoModel.getTransCostlist().iterator();
            while (it5.hasNext()) {
                jSONArray5.put(it5.next());
            }
            jSONObject.put("transCostlist", jSONArray5);
        }
        jSONObject.put("vehicleWeight", rspCarEnergyInfoModel.getVehicleWeight());
        return jSONObject;
    }
}
