package com.autonavi.amapauto.protocol.model.client;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.Keep;
import com.autonavi.amapauto.protocol.constant.StandardProtocolKey;
import com.autonavi.amapauto.protocol.model.base.ProtocolBaseModel;
import defpackage.o60;

@Keep
/* loaded from: classes.dex */
public class RspGetTruckParmModel extends ProtocolBaseModel {
    public static final Parcelable.Creator<RspGetTruckParmModel> CREATOR = new a();
    public int carAxes;
    public double carHeight;
    public double carLength;
    public double carLoading;

    @o60(isLonLat = true)
    public String carPlateNumber;
    public double carRatedLoading;
    public int carType;
    public double carWidth;
    public int powerType;

    /* loaded from: classes.dex */
    public static class a implements Parcelable.Creator<RspGetTruckParmModel> {
        /* JADX WARN: Can't rename method to resolve collision */
        @Override // android.os.Parcelable.Creator
        public RspGetTruckParmModel createFromParcel(Parcel parcel) {
            return new RspGetTruckParmModel(parcel);
        }

        /* JADX WARN: Can't rename method to resolve collision */
        @Override // android.os.Parcelable.Creator
        public RspGetTruckParmModel[] newArray(int i) {
            return new RspGetTruckParmModel[i];
        }
    }

    public RspGetTruckParmModel() {
        this.carAxes = 0;
        this.carHeight = 0.0d;
        this.carLength = 0.0d;
        this.carLoading = 0.0d;
        this.carRatedLoading = 0.0d;
        this.carType = -1;
        this.carWidth = 0.0d;
        this.powerType = -1;
        setProtocolID(80183);
    }

    @Override // com.autonavi.amapauto.protocol.model.base.ProtocolBaseModel, android.os.Parcelable
    public int describeContents() {
        return 0;
    }

    public int getCarAxes() {
        return this.carAxes;
    }

    public double getCarHeight() {
        return this.carHeight;
    }

    public double getCarLength() {
        return this.carLength;
    }

    public double getCarLoading() {
        return this.carLoading;
    }

    public String getCarPlateNumber() {
        return this.carPlateNumber;
    }

    public double getCarRatedLoading() {
        return this.carRatedLoading;
    }

    public int getCarType() {
        return this.carType;
    }

    public double getCarWidth() {
        return this.carWidth;
    }

    public int getPowerType() {
        return this.powerType;
    }

    public void setCarAxes(int i) {
        this.carAxes = i;
    }

    public void setCarHeight(double d) {
        this.carHeight = d;
    }

    public void setCarLength(double d) {
        this.carLength = d;
    }

    public void setCarLoading(double d) {
        this.carLoading = d;
    }

    public void setCarPlateNumber(String str) {
        this.carPlateNumber = str;
    }

    public void setCarRatedLoading(double d) {
        this.carRatedLoading = d;
    }

    public void setCarType(int i) {
        this.carType = i;
    }

    public void setCarWidth(double d) {
        this.carWidth = d;
    }

    public void setPowerType(int i) {
        this.powerType = i;
    }

    public String toString() {
        return StandardProtocolKey.EXTRA_CARAXES + ": " + this.carAxes + "\n" + StandardProtocolKey.EXTRA_CARHEIGHT + ": " + this.carHeight + "\n" + StandardProtocolKey.EXTRA_CARLENGTH + ": " + this.carLength + "\n" + StandardProtocolKey.EXTRA_CARLOADING + ": " + this.carLoading + "\n" + StandardProtocolKey.EXTRA_CARPLATENUMBER + ": " + this.carPlateNumber + "\n" + StandardProtocolKey.EXTRA_CARRATEDLOADING + ": " + this.carRatedLoading + "\n" + StandardProtocolKey.EXTRA_CARTYPE + ": " + this.carType + "\n" + StandardProtocolKey.EXTRA_CARWIDTH + ": " + this.carWidth + "\npowerType: " + this.powerType + "\n";
    }

    @Override // com.autonavi.amapauto.protocol.model.base.ProtocolBaseModel, android.os.Parcelable
    public void writeToParcel(Parcel parcel, int i) {
        super.writeToParcel(parcel, i);
        parcel.writeInt(this.carAxes);
        parcel.writeDouble(this.carHeight);
        parcel.writeDouble(this.carLength);
        parcel.writeDouble(this.carLoading);
        parcel.writeString(this.carPlateNumber);
        parcel.writeDouble(this.carRatedLoading);
        parcel.writeInt(this.carType);
        parcel.writeDouble(this.carWidth);
        parcel.writeInt(this.powerType);
    }

    public RspGetTruckParmModel(Parcel parcel) {
        super(parcel);
        this.carAxes = 0;
        this.carHeight = 0.0d;
        this.carLength = 0.0d;
        this.carLoading = 0.0d;
        this.carRatedLoading = 0.0d;
        this.carType = -1;
        this.carWidth = 0.0d;
        this.powerType = -1;
        this.carAxes = parcel.readInt();
        this.carHeight = parcel.readDouble();
        this.carLength = parcel.readDouble();
        this.carLoading = parcel.readDouble();
        this.carPlateNumber = parcel.readString();
        this.carRatedLoading = parcel.readDouble();
        this.carType = parcel.readInt();
        this.carWidth = parcel.readDouble();
        this.powerType = parcel.readInt();
    }
}
