package com.autonavi.amapauto.protocol.model.client;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.Keep;
import com.autonavi.amapauto.protocol.model.base.ProtocolBaseModel;
import defpackage.o60;

@Keep
/* loaded from: classes.dex */
public class RspNetworkStatusInfoModel extends ProtocolBaseModel {
    public static final Parcelable.Creator<RspNetworkStatusInfoModel> CREATOR = new a();

    @o60(maxValue = 3, minValue = 0)
    public int netStatus;

    @o60(maxValue = 5, minValue = 0)
    public int netType;

    @o60(maxValue = 4, minValue = 0)
    public int strength;

    /* loaded from: classes.dex */
    public static class a implements Parcelable.Creator<RspNetworkStatusInfoModel> {
        /* JADX WARN: Can't rename method to resolve collision */
        @Override // android.os.Parcelable.Creator
        public RspNetworkStatusInfoModel createFromParcel(Parcel parcel) {
            return new RspNetworkStatusInfoModel(parcel);
        }

        /* JADX WARN: Can't rename method to resolve collision */
        @Override // android.os.Parcelable.Creator
        public RspNetworkStatusInfoModel[] newArray(int i) {
            return new RspNetworkStatusInfoModel[i];
        }
    }

    public RspNetworkStatusInfoModel() {
        this.netStatus = 1;
        this.netType = 0;
        this.strength = 4;
        setProtocolID(80133);
    }

    @Override // com.autonavi.amapauto.protocol.model.base.ProtocolBaseModel, android.os.Parcelable
    public int describeContents() {
        return 0;
    }

    public int getNetStatus() {
        return this.netStatus;
    }

    public int getNetType() {
        return this.netType;
    }

    public int getStrength() {
        return this.strength;
    }

    public void setNetStatus(int i) {
        this.netStatus = i;
    }

    public void setNetType(int i) {
        this.netType = i;
    }

    public void setStrength(int i) {
        this.strength = i;
    }

    public String toString() {
        return "netStatus: " + this.netStatus + "\nnetType: " + this.netType + "\nstrength: " + this.strength + "\n";
    }

    @Override // com.autonavi.amapauto.protocol.model.base.ProtocolBaseModel, android.os.Parcelable
    public void writeToParcel(Parcel parcel, int i) {
        super.writeToParcel(parcel, i);
        parcel.writeInt(this.netStatus);
        parcel.writeInt(this.netType);
        parcel.writeInt(this.strength);
    }

    public RspNetworkStatusInfoModel(Parcel parcel) {
        super(parcel);
        this.netStatus = 1;
        this.netType = 0;
        this.strength = 4;
        this.netStatus = parcel.readInt();
        this.netType = parcel.readInt();
        this.strength = parcel.readInt();
    }
}
