package com.autonavi.amapauto.protocol.model.client;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.Keep;
import com.autonavi.amapauto.protocol.model.base.ProtocolBaseModel;
import defpackage.o60;

@Keep
/* loaded from: classes.dex */
public class SetSpecialPoiModel extends ProtocolBaseModel {
    public static final Parcelable.Creator<SetSpecialPoiModel> CREATOR = new a();
    public String address;

    @o60(maxValue = 1, minValue = 0)
    public int dev;
    public double entry_latitude;
    public double entry_longitude;

    @o60(isLonLat = true, isMustFill = true)
    public double latitude;

    @o60(isLonLat = true, isMustFill = true)
    public double longitude;
    public String poiId;

    @o60(isMustFill = true)
    public String poiName;

    @o60(isMustFill = true, maxValue = 2, minValue = 1)
    public int type;
    public int typeCode;

    /* loaded from: classes.dex */
    public static class a implements Parcelable.Creator<SetSpecialPoiModel> {
        /* JADX WARN: Can't rename method to resolve collision */
        @Override // android.os.Parcelable.Creator
        public SetSpecialPoiModel createFromParcel(Parcel parcel) {
            return new SetSpecialPoiModel(parcel);
        }

        /* JADX WARN: Can't rename method to resolve collision */
        @Override // android.os.Parcelable.Creator
        public SetSpecialPoiModel[] newArray(int i) {
            return new SetSpecialPoiModel[i];
        }
    }

    public SetSpecialPoiModel() {
        setProtocolID(30401);
    }

    @Override // com.autonavi.amapauto.protocol.model.base.ProtocolBaseModel, android.os.Parcelable
    public int describeContents() {
        return 0;
    }

    public String getAddress() {
        return this.address;
    }

    public int getDev() {
        return this.dev;
    }

    public double getEntry_latitude() {
        return this.entry_latitude;
    }

    public double getEntry_longitude() {
        return this.entry_longitude;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public String getPoiId() {
        return this.poiId;
    }

    public String getPoiName() {
        return this.poiName;
    }

    public int getType() {
        return this.type;
    }

    public int getTypeCode() {
        return this.typeCode;
    }

    public void setAddress(String str) {
        this.address = str;
    }

    public void setDev(int i) {
        this.dev = i;
    }

    public void setEntry_latitude(double d) {
        this.entry_latitude = d;
    }

    public void setEntry_longitude(double d) {
        this.entry_longitude = d;
    }

    public void setLatitude(double d) {
        this.latitude = d;
    }

    public void setLongitude(double d) {
        this.longitude = d;
    }

    public void setPoiId(String str) {
        this.poiId = str;
    }

    public void setPoiName(String str) {
        this.poiName = str;
    }

    public void setType(int i) {
        this.type = i;
    }

    public void setTypeCode(int i) {
        this.typeCode = i;
    }

    @Override // com.autonavi.amapauto.protocol.model.base.ProtocolBaseModel, android.os.Parcelable
    public void writeToParcel(Parcel parcel, int i) {
        super.writeToParcel(parcel, i);
        parcel.writeString(this.poiId);
        parcel.writeString(this.poiName);
        parcel.writeDouble(this.longitude);
        parcel.writeDouble(this.latitude);
        parcel.writeDouble(this.entry_longitude);
        parcel.writeDouble(this.entry_latitude);
        parcel.writeString(this.address);
        parcel.writeInt(this.typeCode);
        parcel.writeInt(this.type);
        parcel.writeInt(this.dev);
    }

    public SetSpecialPoiModel(Parcel parcel) {
        super(parcel);
        this.poiId = parcel.readString();
        this.poiName = parcel.readString();
        this.longitude = parcel.readDouble();
        this.latitude = parcel.readDouble();
        this.entry_longitude = parcel.readDouble();
        this.entry_latitude = parcel.readDouble();
        this.address = parcel.readString();
        this.typeCode = parcel.readInt();
        this.type = parcel.readInt();
        this.dev = parcel.readInt();
    }
}
