package com.autonavi.amapauto.protocol.model.client;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.Keep;
import com.autonavi.amapauto.protocol.model.base.ProtocolBaseModel;
import com.autonavi.amapauto.protocol.model.item.ProtocolPoi;
import defpackage.o60;
import java.util.List;

@Keep
/* loaded from: classes.dex */
public class SpecialPoiNaviModel extends ProtocolBaseModel {
    public static final Parcelable.Creator<SpecialPoiNaviModel> CREATOR = new a();
    public int count;

    @o60(isMustFill = true, maxValue = 1, minValue = 0)
    public int destType;

    @o60(maxValue = 1, minValue = 0)
    public int dev;
    public int directNavi;
    public List<ProtocolPoi> midProtocolPois;
    public int newStrategy;

    @o60(intValues = {1, 2, 3, 4, 5, 6, 7, 8, 20, 24, -1})
    public int strategy;

    /* loaded from: classes.dex */
    public static class a implements Parcelable.Creator<SpecialPoiNaviModel> {
        /* JADX WARN: Can't rename method to resolve collision */
        @Override // android.os.Parcelable.Creator
        public SpecialPoiNaviModel createFromParcel(Parcel parcel) {
            return new SpecialPoiNaviModel(parcel);
        }

        /* JADX WARN: Can't rename method to resolve collision */
        @Override // android.os.Parcelable.Creator
        public SpecialPoiNaviModel[] newArray(int i) {
            return new SpecialPoiNaviModel[i];
        }
    }

    public SpecialPoiNaviModel(int i, int i2) {
        this.strategy = -1;
        this.newStrategy = -100;
        this.dev = 0;
        setProtocolID(30400);
        this.destType = i;
        this.directNavi = i2;
    }

    public int getCount() {
        return this.count;
    }

    public int getDestType() {
        return this.destType;
    }

    public int getDev() {
        return this.dev;
    }

    public int getDirectNavi() {
        return this.directNavi;
    }

    public List<ProtocolPoi> getMidProtocolPois() {
        return this.midProtocolPois;
    }

    @Override // com.autonavi.amapauto.protocol.model.base.ProtocolBaseModel
    public int getModelVersion() {
        return 3;
    }

    public int getNewStrategy() {
        return this.newStrategy;
    }

    public int getStrategy() {
        return this.strategy;
    }

    public void setCount(int i) {
        this.count = i;
    }

    public void setDestType(int i) {
        this.destType = i;
    }

    public void setDev(int i) {
        this.dev = i;
    }

    public void setDirectNavi(int i) {
        this.directNavi = i;
    }

    public void setMidProtocolPois(List<ProtocolPoi> list) {
        this.midProtocolPois = list;
    }

    public void setNewStrategy(int i) {
        this.newStrategy = i;
    }

    public void setStrategy(int i) {
        this.strategy = i;
    }

    @Override // com.autonavi.amapauto.protocol.model.base.ProtocolBaseModel, android.os.Parcelable
    public void writeToParcel(Parcel parcel, int i) {
        super.writeToParcel(parcel, i);
        parcel.writeInt(this.destType);
        parcel.writeInt(this.directNavi);
        if (getDataVersion() >= 1) {
            parcel.writeInt(this.strategy);
            parcel.writeInt(this.dev);
            parcel.writeTypedList(this.midProtocolPois);
        }
        if (getDataVersion() >= 2) {
            parcel.writeInt(this.newStrategy);
        }
        if (getDataVersion() >= 3) {
            parcel.writeInt(this.count);
        }
    }

    public SpecialPoiNaviModel(Parcel parcel) {
        super(parcel);
        this.strategy = -1;
        this.newStrategy = -100;
        this.dev = 0;
        this.destType = parcel.readInt();
        this.directNavi = parcel.readInt();
        if (getDataVersion() >= 1) {
            this.strategy = parcel.readInt();
            this.dev = parcel.readInt();
            this.midProtocolPois = parcel.createTypedArrayList(ProtocolPoi.CREATOR);
        }
        if (getDataVersion() >= 2) {
            this.newStrategy = parcel.readInt();
        }
        if (getDataVersion() >= 3) {
            this.count = parcel.readInt();
        }
    }
}
