package com.autonavi.amapauto.protocol.model.client;

import com.autonavi.amapauto.protocol.model.item.ProtocolPoi;
import com.autonavi.amapauto.protocol.model.item.ProtocolPoi_JsonLubeSerializer;
import java.io.Serializable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/* loaded from: classes.dex */
public final class SpecialPoiNaviModel_JsonLubeSerializer implements Serializable {
    public static JSONObject serialize(SpecialPoiNaviModel specialPoiNaviModel) throws JSONException {
        if (specialPoiNaviModel == null) {
            return null;
        }
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("packageName", specialPoiNaviModel.getPackageName());
        jSONObject.put("clientPackageName", specialPoiNaviModel.getClientPackageName());
        jSONObject.put("callbackId", specialPoiNaviModel.getCallbackId());
        jSONObject.put("timeStamp", specialPoiNaviModel.getTimeStamp());
        jSONObject.put("var1", specialPoiNaviModel.getVar1());
        jSONObject.put("destType", specialPoiNaviModel.getDestType());
        jSONObject.put("directNavi", specialPoiNaviModel.getDirectNavi());
        jSONObject.put("strategy", specialPoiNaviModel.getStrategy());
        jSONObject.put("dev", specialPoiNaviModel.getDev());
        if (specialPoiNaviModel.getMidProtocolPois() != null) {
            JSONArray jSONArray = new JSONArray();
            for (ProtocolPoi protocolPoi : specialPoiNaviModel.getMidProtocolPois()) {
                if (protocolPoi != null) {
                    jSONArray.put(ProtocolPoi_JsonLubeSerializer.serialize(protocolPoi));
                }
            }
            jSONObject.put("midProtocolPois", jSONArray);
        }
        jSONObject.put("newStrategy", specialPoiNaviModel.getNewStrategy());
        jSONObject.put("count", specialPoiNaviModel.getCount());
        return jSONObject;
    }
}
