package com.autonavi.amapauto.protocol.model.client;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.Keep;
import com.autonavi.amapauto.protocol.model.base.ProtocolBaseModel;
import defpackage.o60;
import java.util.ArrayList;

@Keep
/* loaded from: classes.dex */
public class TSRInfoModel extends ProtocolBaseModel {
    public static final Parcelable.Creator<TSRInfoModel> CREATOR = new a();

    @o60(isMustFill = true)
    public int horizontalDistance;
    public int laneDistance;
    public ArrayList<Integer> otherSpeedLimitValues;

    @o60(maxValue = 6, minValue = 0)
    public int signType;

    @o60(isMustFill = true)
    public int speedLimitValue;

    @o60(isMustFill = true)
    public int verticalDistance;

    /* loaded from: classes.dex */
    public static class a implements Parcelable.Creator<TSRInfoModel> {
        /* JADX WARN: Can't rename method to resolve collision */
        @Override // android.os.Parcelable.Creator
        public TSRInfoModel createFromParcel(Parcel parcel) {
            return new TSRInfoModel(parcel);
        }

        /* JADX WARN: Can't rename method to resolve collision */
        @Override // android.os.Parcelable.Creator
        public TSRInfoModel[] newArray(int i) {
            return new TSRInfoModel[i];
        }
    }

    public TSRInfoModel() {
        setProtocolID(30413);
    }

    @Override // com.autonavi.amapauto.protocol.model.base.ProtocolBaseModel, android.os.Parcelable
    public int describeContents() {
        return 0;
    }

    public int getHorizontalDistance() {
        return this.horizontalDistance;
    }

    public int getLaneDistance() {
        return this.laneDistance;
    }

    public ArrayList<Integer> getOtherSpeedLimitValues() {
        return this.otherSpeedLimitValues;
    }

    public int getSignType() {
        return this.signType;
    }

    public int getSpeedLimitValue() {
        return this.speedLimitValue;
    }

    public int getVerticalDistance() {
        return this.verticalDistance;
    }

    public void setHorizontalDistance(int i) {
        this.horizontalDistance = i;
    }

    public void setLaneDistance(int i) {
        this.laneDistance = i;
    }

    public void setOtherSpeedLimitValues(ArrayList<Integer> arrayList) {
        this.otherSpeedLimitValues = arrayList;
    }

    public void setSignType(int i) {
        this.signType = i;
    }

    public void setSpeedLimitValue(int i) {
        this.speedLimitValue = i;
    }

    public void setVerticalDistance(int i) {
        this.verticalDistance = i;
    }

    @Override // com.autonavi.amapauto.protocol.model.base.ProtocolBaseModel, android.os.Parcelable
    public void writeToParcel(Parcel parcel, int i) {
        super.writeToParcel(parcel, i);
        parcel.writeInt(this.speedLimitValue);
        parcel.writeInt(this.horizontalDistance);
        parcel.writeInt(this.verticalDistance);
        parcel.writeInt(this.signType);
        parcel.writeInt(this.laneDistance);
        parcel.writeList(this.otherSpeedLimitValues);
    }

    public TSRInfoModel(Parcel parcel) {
        super(parcel);
        this.speedLimitValue = parcel.readInt();
        this.horizontalDistance = parcel.readInt();
        this.verticalDistance = parcel.readInt();
        this.signType = parcel.readInt();
        this.laneDistance = parcel.readInt();
        ArrayList<Integer> arrayList = new ArrayList<>();
        this.otherSpeedLimitValues = arrayList;
        parcel.readList(arrayList, Integer.class.getClassLoader());
    }
}
