package com.autonavi.amapauto.protocol.model.client;

import java.io.Serializable;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONObject;

/* loaded from: classes.dex */
public final class TSRInfoModel_JsonLubeParser implements Serializable {
    public static TSRInfoModel parse(JSONObject jSONObject) {
        if (jSONObject == null) {
            return null;
        }
        TSRInfoModel tSRInfoModel = new TSRInfoModel();
        tSRInfoModel.setClientPackageName(jSONObject.optString("clientPackageName", tSRInfoModel.getClientPackageName()));
        tSRInfoModel.setPackageName(jSONObject.optString("packageName", tSRInfoModel.getPackageName()));
        tSRInfoModel.setCallbackId(jSONObject.optInt("callbackId", tSRInfoModel.getCallbackId()));
        tSRInfoModel.setTimeStamp(jSONObject.optLong("timeStamp", tSRInfoModel.getTimeStamp()));
        tSRInfoModel.setVar1(jSONObject.optString("var1", tSRInfoModel.getVar1()));
        tSRInfoModel.setSpeedLimitValue(jSONObject.optInt("speedLimitValue", tSRInfoModel.getSpeedLimitValue()));
        tSRInfoModel.setHorizontalDistance(jSONObject.optInt("horizontalDistance", tSRInfoModel.getHorizontalDistance()));
        tSRInfoModel.setVerticalDistance(jSONObject.optInt("verticalDistance", tSRInfoModel.getVerticalDistance()));
        tSRInfoModel.setSignType(jSONObject.optInt("signType", tSRInfoModel.getSignType()));
        tSRInfoModel.setLaneDistance(jSONObject.optInt("laneDistance", tSRInfoModel.getLaneDistance()));
        JSONArray optJSONArray = jSONObject.optJSONArray("otherSpeedLimitValues");
        if (optJSONArray != null) {
            int length = optJSONArray.length();
            ArrayList<Integer> arrayList = new ArrayList<>(length);
            for (int i = 0; i < length; i++) {
                arrayList.add(Integer.valueOf(optJSONArray.optInt(i)));
            }
            tSRInfoModel.setOtherSpeedLimitValues(arrayList);
        }
        return tSRInfoModel;
    }
}
