package com.autonavi.amapauto.protocol.model.client;

import java.io.Serializable;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/* loaded from: classes.dex */
public final class TSRInfoModel_JsonLubeSerializer implements Serializable {
    public static JSONObject serialize(TSRInfoModel tSRInfoModel) throws JSONException {
        if (tSRInfoModel == null) {
            return null;
        }
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("packageName", tSRInfoModel.getPackageName());
        jSONObject.put("clientPackageName", tSRInfoModel.getClientPackageName());
        jSONObject.put("callbackId", tSRInfoModel.getCallbackId());
        jSONObject.put("timeStamp", tSRInfoModel.getTimeStamp());
        jSONObject.put("var1", tSRInfoModel.getVar1());
        jSONObject.put("speedLimitValue", tSRInfoModel.getSpeedLimitValue());
        jSONObject.put("horizontalDistance", tSRInfoModel.getHorizontalDistance());
        jSONObject.put("verticalDistance", tSRInfoModel.getVerticalDistance());
        jSONObject.put("signType", tSRInfoModel.getSignType());
        jSONObject.put("laneDistance", tSRInfoModel.getLaneDistance());
        if (tSRInfoModel.getOtherSpeedLimitValues() != null) {
            JSONArray jSONArray = new JSONArray();
            Iterator<Integer> it = tSRInfoModel.getOtherSpeedLimitValues().iterator();
            while (it.hasNext()) {
                jSONArray.put(it.next());
            }
            jSONObject.put("otherSpeedLimitValues", jSONArray);
        }
        return jSONObject;
    }
}
