package com.autonavi.amapauto.protocol.model.client;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.Keep;
import com.autonavi.amapauto.protocol.model.base.ProtocolBaseModel;
import defpackage.o60;

@Keep
/* loaded from: classes.dex */
public class ViewPoiModel extends ProtocolBaseModel {
    public static final Parcelable.Creator<ViewPoiModel> CREATOR = new a();
    public String address;
    public int encryptType;
    public double entryLatitude;
    public double entryLongitude;

    @o60(isLonLat = true, isMustFill = true)
    public double latitude;

    @o60(isLonLat = true, isMustFill = true)
    public double longitude;
    public String poiName;
    public String poiid;

    @o60(isMustFill = true, maxValue = 2, minValue = 0)
    public int type;

    /* loaded from: classes.dex */
    public static class a implements Parcelable.Creator<ViewPoiModel> {
        /* JADX WARN: Can't rename method to resolve collision */
        @Override // android.os.Parcelable.Creator
        public ViewPoiModel createFromParcel(Parcel parcel) {
            return new ViewPoiModel(parcel);
        }

        /* JADX WARN: Can't rename method to resolve collision */
        @Override // android.os.Parcelable.Creator
        public ViewPoiModel[] newArray(int i) {
            return new ViewPoiModel[i];
        }
    }

    public ViewPoiModel() {
        setProtocolID(30012);
    }

    @Override // com.autonavi.amapauto.protocol.model.base.ProtocolBaseModel, android.os.Parcelable
    public int describeContents() {
        return 0;
    }

    public String getAddress() {
        return this.address;
    }

    public int getEncryptType() {
        return this.encryptType;
    }

    public double getEntryLatitude() {
        return this.entryLatitude;
    }

    public double getEntryLongitude() {
        return this.entryLongitude;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    @Override // com.autonavi.amapauto.protocol.model.base.ProtocolBaseModel
    public int getModelVersion() {
        return 1;
    }

    public String getPoiName() {
        return this.poiName;
    }

    public String getPoiid() {
        return this.poiid;
    }

    public int getType() {
        return this.type;
    }

    public void setAddress(String str) {
        this.address = str;
    }

    public void setEncryptType(int i) {
        this.encryptType = i;
    }

    public void setEntryLatitude(double d) {
        this.entryLatitude = d;
    }

    public void setEntryLongitude(double d) {
        this.entryLongitude = d;
    }

    public void setLatitude(double d) {
        this.latitude = d;
    }

    public void setLongitude(double d) {
        this.longitude = d;
    }

    public void setPoiName(String str) {
        this.poiName = str;
    }

    public void setPoiid(String str) {
        this.poiid = str;
    }

    public void setType(int i) {
        this.type = i;
    }

    @Override // com.autonavi.amapauto.protocol.model.base.ProtocolBaseModel, android.os.Parcelable
    public void writeToParcel(Parcel parcel, int i) {
        super.writeToParcel(parcel, i);
        parcel.writeInt(this.type);
        parcel.writeDouble(this.longitude);
        parcel.writeDouble(this.latitude);
        parcel.writeInt(this.encryptType);
        parcel.writeString(this.address);
        parcel.writeString(this.poiName);
        if (getDataVersion() >= 1) {
            parcel.writeString(this.poiid);
            parcel.writeDouble(this.entryLongitude);
            parcel.writeDouble(this.entryLatitude);
        }
    }

    public ViewPoiModel(Parcel parcel) {
        super(parcel);
        this.type = parcel.readInt();
        this.longitude = parcel.readDouble();
        this.latitude = parcel.readDouble();
        this.encryptType = parcel.readInt();
        this.address = parcel.readString();
        this.poiName = parcel.readString();
        if (getDataVersion() >= 1) {
            this.poiid = parcel.readString();
            this.entryLongitude = parcel.readDouble();
            this.entryLatitude = parcel.readDouble();
        }
    }
}
