package com.autonavi.amapauto.protocol.model.client;

import com.autonavi.amapauto.protocol.constant.StandardProtocolKey;
import java.io.Serializable;
import org.json.JSONObject;

/* loaded from: classes.dex */
public final class ViewPoiModel_JsonLubeParser implements Serializable {
    public static ViewPoiModel parse(JSONObject jSONObject) {
        if (jSONObject == null) {
            return null;
        }
        ViewPoiModel viewPoiModel = new ViewPoiModel();
        viewPoiModel.setClientPackageName(jSONObject.optString("clientPackageName", viewPoiModel.getClientPackageName()));
        viewPoiModel.setPackageName(jSONObject.optString("packageName", viewPoiModel.getPackageName()));
        viewPoiModel.setCallbackId(jSONObject.optInt("callbackId", viewPoiModel.getCallbackId()));
        viewPoiModel.setTimeStamp(jSONObject.optLong("timeStamp", viewPoiModel.getTimeStamp()));
        viewPoiModel.setVar1(jSONObject.optString("var1", viewPoiModel.getVar1()));
        viewPoiModel.setPoiid(jSONObject.optString(StandardProtocolKey.POIID, viewPoiModel.getPoiid()));
        viewPoiModel.setEntryLongitude(jSONObject.optDouble(StandardProtocolKey.EXTRA_ENTRYLONGITUDE, viewPoiModel.getEntryLongitude()));
        viewPoiModel.setEntryLatitude(jSONObject.optDouble(StandardProtocolKey.EXTRA_ENTRYLATITUDE, viewPoiModel.getEntryLatitude()));
        viewPoiModel.setType(jSONObject.optInt("type", viewPoiModel.getType()));
        viewPoiModel.setLongitude(jSONObject.optDouble("longitude", viewPoiModel.getLongitude()));
        viewPoiModel.setLatitude(jSONObject.optDouble("latitude", viewPoiModel.getLatitude()));
        viewPoiModel.setEncryptType(jSONObject.optInt("encryptType", viewPoiModel.getEncryptType()));
        viewPoiModel.setAddress(jSONObject.optString(StandardProtocolKey.POI_ADDRESS, viewPoiModel.getAddress()));
        viewPoiModel.setPoiName(jSONObject.optString(StandardProtocolKey.EXTRA_POINAME, viewPoiModel.getPoiName()));
        return viewPoiModel;
    }
}
