package com.autonavi.amapauto.protocol.model.client;

import com.autonavi.amapauto.protocol.constant.StandardProtocolKey;
import java.io.Serializable;
import org.json.JSONException;
import org.json.JSONObject;

/* loaded from: classes.dex */
public final class ViewPoiModel_JsonLubeSerializer implements Serializable {
    public static JSONObject serialize(ViewPoiModel viewPoiModel) throws JSONException {
        if (viewPoiModel == null) {
            return null;
        }
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("packageName", viewPoiModel.getPackageName());
        jSONObject.put("clientPackageName", viewPoiModel.getClientPackageName());
        jSONObject.put("callbackId", viewPoiModel.getCallbackId());
        jSONObject.put("timeStamp", viewPoiModel.getTimeStamp());
        jSONObject.put("var1", viewPoiModel.getVar1());
        jSONObject.put(StandardProtocolKey.POIID, viewPoiModel.getPoiid());
        jSONObject.put(StandardProtocolKey.EXTRA_ENTRYLONGITUDE, viewPoiModel.getEntryLongitude());
        jSONObject.put(StandardProtocolKey.EXTRA_ENTRYLATITUDE, viewPoiModel.getEntryLatitude());
        jSONObject.put("type", viewPoiModel.getType());
        jSONObject.put("longitude", viewPoiModel.getLongitude());
        jSONObject.put("latitude", viewPoiModel.getLatitude());
        jSONObject.put("encryptType", viewPoiModel.getEncryptType());
        jSONObject.put(StandardProtocolKey.POI_ADDRESS, viewPoiModel.getAddress());
        jSONObject.put(StandardProtocolKey.EXTRA_POINAME, viewPoiModel.getPoiName());
        return jSONObject;
    }
}
