package com.autonavi.amapauto.protocol.model.client.common;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.Keep;
import com.autonavi.amapauto.protocol.model.base.ProtocolBaseModel;
import java.util.HashMap;
import java.util.Map;

@Keep
/* loaded from: classes.dex */
public class ProtocolVersionModel extends ProtocolBaseModel {
    public static final Parcelable.Creator<ProtocolVersionModel> CREATOR = new a();
    public Map<String, Integer> mapClientModelVersion;
    public Map<String, Integer> mapServiceModelVersion;
    public String versionName;

    /* loaded from: classes.dex */
    public static class a implements Parcelable.Creator<ProtocolVersionModel> {
        /* JADX WARN: Can't rename method to resolve collision */
        @Override // android.os.Parcelable.Creator
        public ProtocolVersionModel createFromParcel(Parcel parcel) {
            return new ProtocolVersionModel(parcel);
        }

        /* JADX WARN: Can't rename method to resolve collision */
        @Override // android.os.Parcelable.Creator
        public ProtocolVersionModel[] newArray(int i) {
            return new ProtocolVersionModel[i];
        }
    }

    public ProtocolVersionModel(String str, Map<String, Integer> map) {
        this.versionName = "";
        this.mapClientModelVersion = new HashMap();
        this.mapServiceModelVersion = new HashMap();
        this.versionName = str;
        this.mapServiceModelVersion = map;
        setProtocolID(99999);
    }

    @Override // com.autonavi.amapauto.protocol.model.base.ProtocolBaseModel, android.os.Parcelable
    public int describeContents() {
        return 0;
    }

    public Map<String, Integer> getMapClientModelVersion() {
        return this.mapClientModelVersion;
    }

    public Map<String, Integer> getMapServiceModelVersion() {
        return this.mapServiceModelVersion;
    }

    @Override // com.autonavi.amapauto.protocol.model.base.ProtocolBaseModel
    public int getModelVersion() {
        return 2;
    }

    public String getVersionName() {
        return this.versionName;
    }

    public void setVersionName(String str) {
        this.versionName = str;
    }

    @Override // com.autonavi.amapauto.protocol.model.base.ProtocolBaseModel, android.os.Parcelable
    public void writeToParcel(Parcel parcel, int i) {
        super.writeToParcel(parcel, i);
        parcel.writeString(this.versionName);
        if (getDataVersion() >= 1) {
            parcel.writeMap(this.mapClientModelVersion);
        }
        if (getDataVersion() >= 2) {
            parcel.writeMap(this.mapServiceModelVersion);
        }
    }

    public ProtocolVersionModel(Parcel parcel) {
        super(parcel);
        this.versionName = "";
        this.mapClientModelVersion = new HashMap();
        this.mapServiceModelVersion = new HashMap();
        this.versionName = parcel.readString();
        if (getDataVersion() >= 1) {
            this.mapClientModelVersion = parcel.readHashMap(HashMap.class.getClassLoader());
        }
        if (getDataVersion() >= 2) {
            this.mapServiceModelVersion = parcel.readHashMap(HashMap.class.getClassLoader());
        }
    }
}
