package com.autonavi.amapauto.protocol.model.client.drive_module;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.Keep;
import com.autonavi.amapauto.protocol.model.base.ProtocolBaseModel;

@Keep
/* loaded from: classes.dex */
public class TripReporterModel extends ProtocolBaseModel {
    public static final Parcelable.Creator<TripReporterModel> CREATOR = new a();
    public static final String VERSION = "1.0";
    public String aveSpeed;
    public String driveDistance;
    public String driveTime;
    public String highestSpeed;

    /* loaded from: classes.dex */
    public static class a implements Parcelable.Creator<TripReporterModel> {
        /* JADX WARN: Can't rename method to resolve collision */
        @Override // android.os.Parcelable.Creator
        public TripReporterModel createFromParcel(Parcel parcel) {
            return new TripReporterModel(parcel);
        }

        /* JADX WARN: Can't rename method to resolve collision */
        @Override // android.os.Parcelable.Creator
        public TripReporterModel[] newArray(int i) {
            return new TripReporterModel[i];
        }
    }

    public TripReporterModel() {
        setProtocolID(30430);
    }

    @Override // com.autonavi.amapauto.protocol.model.base.ProtocolBaseModel, android.os.Parcelable
    public int describeContents() {
        return 0;
    }

    public String getAveSpeed() {
        return this.aveSpeed;
    }

    public String getDriveDistance() {
        return this.driveDistance;
    }

    public String getDriveTime() {
        return this.driveTime;
    }

    public String getHighestSpeed() {
        return this.highestSpeed;
    }

    @Override // com.autonavi.amapauto.protocol.model.base.ProtocolBaseModel
    public int getModelVersion() {
        return 1;
    }

    public void setAveSpeed(String str) {
        this.aveSpeed = str;
    }

    public void setDriveDistance(String str) {
        this.driveDistance = str;
    }

    public void setDriveTime(String str) {
        this.driveTime = str;
    }

    public void setHighestSpeed(String str) {
        this.highestSpeed = str;
    }

    @Override // com.autonavi.amapauto.protocol.model.base.ProtocolBaseModel, android.os.Parcelable
    public void writeToParcel(Parcel parcel, int i) {
        super.writeToParcel(parcel, i);
        parcel.writeString(this.driveDistance);
        parcel.writeString(this.driveTime);
        parcel.writeString(this.aveSpeed);
        if (getDataVersion() >= 1) {
            parcel.writeString(this.highestSpeed);
        }
    }

    public TripReporterModel(String str, String str2, String str3) {
        this.driveDistance = str;
        this.driveTime = str2;
        this.aveSpeed = str3;
        setProtocolID(30430);
    }

    public TripReporterModel(Parcel parcel) {
        super(parcel);
        this.driveDistance = parcel.readString();
        this.driveTime = parcel.readString();
        this.aveSpeed = parcel.readString();
        if (getDataVersion() >= 1) {
            this.highestSpeed = parcel.readString();
        }
    }
}
