package com.autonavi.amapauto.protocol.model.client.search;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.Keep;
import com.alibaba.wireless.security.SecExceptionCode;
import defpackage.o60;

@Keep
/* loaded from: classes.dex */
public class AroundSearchModel extends SearchBaseModel {
    public static final Parcelable.Creator<AroundSearchModel> CREATOR = new a();
    public int displayID;
    public String location;

    @o60(maxValue = 50000, minValue = 1)
    public int radius;

    @o60(maxValue = 1, minValue = 0)
    public int sortrule;

    /* loaded from: classes.dex */
    public static class a implements Parcelable.Creator<AroundSearchModel> {
        /* JADX WARN: Can't rename method to resolve collision */
        @Override // android.os.Parcelable.Creator
        public AroundSearchModel createFromParcel(Parcel parcel) {
            return new AroundSearchModel(parcel);
        }

        /* JADX WARN: Can't rename method to resolve collision */
        @Override // android.os.Parcelable.Creator
        public AroundSearchModel[] newArray(int i) {
            return new AroundSearchModel[i];
        }
    }

    public AroundSearchModel(Parcel parcel) {
        super(parcel);
        this.radius = SecExceptionCode.SEC_ERROR_ORANGE;
        this.sortrule = 0;
        this.location = parcel.readString();
        this.radius = parcel.readInt();
        this.sortrule = parcel.readInt();
        if (getModelVersion() >= 4) {
            this.displayID = parcel.readInt();
        }
    }

    @Override // com.autonavi.amapauto.protocol.model.client.search.SearchBaseModel, com.autonavi.amapauto.protocol.model.base.ProtocolBaseModel, android.os.Parcelable
    public int describeContents() {
        return 0;
    }

    public int getDisplayID() {
        return this.displayID;
    }

    public String getLocation() {
        return this.location;
    }

    @Override // com.autonavi.amapauto.protocol.model.client.search.SearchBaseModel, com.autonavi.amapauto.protocol.model.base.ProtocolBaseModel
    public int getModelVersion() {
        return 4;
    }

    public int getRadius() {
        return this.radius;
    }

    public int getSortrule() {
        return this.sortrule;
    }

    public void setDisplayID(int i) {
        this.displayID = i;
    }

    public void setLocation(String str) {
        this.location = str;
    }

    public void setRadius(int i) {
        this.radius = i;
    }

    public void setSortrule(int i) {
        this.sortrule = i;
    }

    @Override // com.autonavi.amapauto.protocol.model.client.search.SearchBaseModel
    public String toString() {
        return "AroundSearchModel{location='" + this.location + "', radius=" + this.radius + ", sortrule=" + this.sortrule + ", displayID=" + this.displayID + '}' + super.toString();
    }

    @Override // com.autonavi.amapauto.protocol.model.client.search.SearchBaseModel, com.autonavi.amapauto.protocol.model.base.ProtocolBaseModel, android.os.Parcelable
    public void writeToParcel(Parcel parcel, int i) {
        super.writeToParcel(parcel, i);
        parcel.writeString(this.location);
        parcel.writeInt(this.radius);
        parcel.writeInt(this.sortrule);
        if (getModelVersion() >= 4) {
            parcel.writeInt(this.displayID);
        }
    }

    public AroundSearchModel() {
        this.radius = SecExceptionCode.SEC_ERROR_ORANGE;
        this.sortrule = 0;
    }

    public AroundSearchModel(int i, String str) {
        this.radius = SecExceptionCode.SEC_ERROR_ORANGE;
        this.sortrule = 0;
        setSearchType(i);
        setKeywords(str);
        setProtocolID(30301);
    }
}
