package com.autonavi.amapauto.protocol.model.client.search;

import com.autonavi.amapauto.protocol.constant.StandardProtocolKey;
import java.io.Serializable;
import org.json.JSONObject;

/* loaded from: classes.dex */
public final class AroundSearchModel_JsonLubeParser implements Serializable {
    public static AroundSearchModel parse(JSONObject jSONObject) {
        if (jSONObject == null) {
            return null;
        }
        AroundSearchModel aroundSearchModel = new AroundSearchModel();
        aroundSearchModel.setClientPackageName(jSONObject.optString("clientPackageName", aroundSearchModel.getClientPackageName()));
        aroundSearchModel.setPackageName(jSONObject.optString("packageName", aroundSearchModel.getPackageName()));
        aroundSearchModel.setCallbackId(jSONObject.optInt("callbackId", aroundSearchModel.getCallbackId()));
        aroundSearchModel.setTimeStamp(jSONObject.optLong("timeStamp", aroundSearchModel.getTimeStamp()));
        aroundSearchModel.setVar1(jSONObject.optString("var1", aroundSearchModel.getVar1()));
        aroundSearchModel.setSearchType(jSONObject.optInt("searchType", aroundSearchModel.getSearchType()));
        aroundSearchModel.setKeywords(jSONObject.optString("keywords", aroundSearchModel.getKeywords()));
        aroundSearchModel.setMylocLon(jSONObject.optDouble("mylocLon", aroundSearchModel.getMylocLon()));
        aroundSearchModel.setMylocLat(jSONObject.optDouble("mylocLat", aroundSearchModel.getMylocLat()));
        aroundSearchModel.setMaxMount(jSONObject.optInt("maxCount", aroundSearchModel.getMaxMount()));
        aroundSearchModel.setDev(jSONObject.optInt("dev", aroundSearchModel.getDev()));
        aroundSearchModel.setNeedClassify(jSONObject.optInt("needClassify", aroundSearchModel.getNeedClassify()));
        aroundSearchModel.setNeedSort(jSONObject.optInt("needSort", aroundSearchModel.getNeedSort()));
        aroundSearchModel.setNeedRange(jSONObject.optInt("needRange", aroundSearchModel.getNeedRange()));
        aroundSearchModel.setNeedCharge(jSONObject.optInt("needCharge", aroundSearchModel.getNeedCharge()));
        aroundSearchModel.setNeedChildPoi(jSONObject.optInt("needChildPoi", aroundSearchModel.getNeedChildPoi()));
        aroundSearchModel.setClassify(jSONObject.optString("classify", aroundSearchModel.getClassify()));
        aroundSearchModel.setSort(jSONObject.optString("sort", aroundSearchModel.getSort()));
        aroundSearchModel.setRange(jSONObject.optString("range", aroundSearchModel.getRange()));
        aroundSearchModel.setCharge(jSONObject.optString("charge", aroundSearchModel.getCharge()));
        aroundSearchModel.setRequestType(jSONObject.optInt(StandardProtocolKey.EXTRA_REQUESTTYPE, aroundSearchModel.getRequestType()));
        aroundSearchModel.setLocation(jSONObject.optString("location", aroundSearchModel.getLocation()));
        aroundSearchModel.setRadius(jSONObject.optInt("radius", aroundSearchModel.getRadius()));
        aroundSearchModel.setSortrule(jSONObject.optInt("sortrule", aroundSearchModel.getSortrule()));
        aroundSearchModel.setDisplayID(jSONObject.optInt("displayID", aroundSearchModel.getDisplayID()));
        return aroundSearchModel;
    }
}
