package com.autonavi.amapauto.protocol.model.client.search;

import com.autonavi.amapauto.protocol.constant.StandardProtocolKey;
import java.io.Serializable;
import org.json.JSONException;
import org.json.JSONObject;

/* loaded from: classes.dex */
public final class AroundSearchModel_JsonLubeSerializer implements Serializable {
    public static JSONObject serialize(AroundSearchModel aroundSearchModel) throws JSONException {
        if (aroundSearchModel == null) {
            return null;
        }
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("packageName", aroundSearchModel.getPackageName());
        jSONObject.put("clientPackageName", aroundSearchModel.getClientPackageName());
        jSONObject.put("callbackId", aroundSearchModel.getCallbackId());
        jSONObject.put("timeStamp", aroundSearchModel.getTimeStamp());
        jSONObject.put("var1", aroundSearchModel.getVar1());
        jSONObject.put("searchType", aroundSearchModel.getSearchType());
        jSONObject.put("keywords", aroundSearchModel.getKeywords());
        jSONObject.put("mylocLon", aroundSearchModel.getMylocLon());
        jSONObject.put("mylocLat", aroundSearchModel.getMylocLat());
        jSONObject.put("maxCount", aroundSearchModel.getMaxMount());
        jSONObject.put("dev", aroundSearchModel.getDev());
        jSONObject.put("needClassify", aroundSearchModel.getNeedClassify());
        jSONObject.put("needSort", aroundSearchModel.getNeedSort());
        jSONObject.put("needRange", aroundSearchModel.getNeedRange());
        jSONObject.put("needCharge", aroundSearchModel.getNeedCharge());
        jSONObject.put("needChildPoi", aroundSearchModel.getNeedChildPoi());
        jSONObject.put("classify", aroundSearchModel.getClassify());
        jSONObject.put("sort", aroundSearchModel.getSort());
        jSONObject.put("range", aroundSearchModel.getRange());
        jSONObject.put("charge", aroundSearchModel.getCharge());
        jSONObject.put(StandardProtocolKey.EXTRA_REQUESTTYPE, aroundSearchModel.getRequestType());
        jSONObject.put("location", aroundSearchModel.getLocation());
        jSONObject.put("radius", aroundSearchModel.getRadius());
        jSONObject.put("sortrule", aroundSearchModel.getSortrule());
        jSONObject.put("displayID", aroundSearchModel.getDisplayID());
        return jSONObject;
    }
}
