package com.autonavi.amapauto.protocol.model.client.search;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.Keep;
import com.alibaba.wireless.security.SecExceptionCode;
import com.autonavi.amapauto.protocol.model.base.ProtocolBaseModel;
import defpackage.o60;

@Keep
/* loaded from: classes.dex */
public class HomeCompanyAroundSearchModel extends ProtocolBaseModel {
    public static final Parcelable.Creator<HomeCompanyAroundSearchModel> CREATOR = new a();

    @o60(isMustFill = true)
    public String keyWord;

    @o60(maxValue = 30, minValue = 1)
    public int maxCount;

    @o60(maxValue = 5000, minValue = 1)
    public int radius;

    @o60(isMustFill = true, maxValue = 1, minValue = 0)
    public int searchCenter;

    @o60(maxValue = 1, minValue = 0)
    public int sortrule;

    /* loaded from: classes.dex */
    public static class a implements Parcelable.Creator<HomeCompanyAroundSearchModel> {
        /* JADX WARN: Can't rename method to resolve collision */
        @Override // android.os.Parcelable.Creator
        public HomeCompanyAroundSearchModel createFromParcel(Parcel parcel) {
            return new HomeCompanyAroundSearchModel(parcel);
        }

        /* JADX WARN: Can't rename method to resolve collision */
        @Override // android.os.Parcelable.Creator
        public HomeCompanyAroundSearchModel[] newArray(int i) {
            return new HomeCompanyAroundSearchModel[i];
        }
    }

    public HomeCompanyAroundSearchModel() {
        this.radius = SecExceptionCode.SEC_ERROR_ORANGE;
        this.sortrule = 0;
        this.maxCount = 10;
        setProtocolID(30304);
    }

    @Override // com.autonavi.amapauto.protocol.model.base.ProtocolBaseModel, android.os.Parcelable
    public int describeContents() {
        return 0;
    }

    public String getKeyWord() {
        return this.keyWord;
    }

    public int getMaxCount() {
        return this.maxCount;
    }

    public int getRadius() {
        return this.radius;
    }

    public int getSearchCenter() {
        return this.searchCenter;
    }

    public int getSortrule() {
        return this.sortrule;
    }

    public void setKeyWord(String str) {
        this.keyWord = str;
    }

    public void setMaxCount(int i) {
        this.maxCount = i;
    }

    public void setRadius(int i) {
        this.radius = i;
    }

    public void setSearchCenter(int i) {
        this.searchCenter = i;
    }

    public void setSortrule(int i) {
        this.sortrule = i;
    }

    @Override // com.autonavi.amapauto.protocol.model.base.ProtocolBaseModel, android.os.Parcelable
    public void writeToParcel(Parcel parcel, int i) {
        super.writeToParcel(parcel, i);
        parcel.writeInt(this.searchCenter);
        parcel.writeString(this.keyWord);
        parcel.writeInt(this.radius);
        parcel.writeInt(this.sortrule);
        parcel.writeInt(this.maxCount);
    }

    public HomeCompanyAroundSearchModel(Parcel parcel) {
        super(parcel);
        this.radius = SecExceptionCode.SEC_ERROR_ORANGE;
        this.sortrule = 0;
        this.maxCount = 10;
        this.searchCenter = parcel.readInt();
        this.keyWord = parcel.readString();
        this.radius = parcel.readInt();
        this.sortrule = parcel.readInt();
        this.maxCount = parcel.readInt();
    }
}
