package com.autonavi.amapauto.protocol.model.client.search;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.Keep;
import defpackage.o60;

@Keep
/* loaded from: classes.dex */
public class KeyWordSearchModel extends SearchBaseModel {
    public static final Parcelable.Creator<KeyWordSearchModel> CREATOR = new a();
    public String city;
    public boolean isRecommend;

    @o60(maxValue = 1, minValue = 0)
    public int sortrule;

    /* loaded from: classes.dex */
    public static class a implements Parcelable.Creator<KeyWordSearchModel> {
        /* JADX WARN: Can't rename method to resolve collision */
        @Override // android.os.Parcelable.Creator
        public KeyWordSearchModel createFromParcel(Parcel parcel) {
            return new KeyWordSearchModel(parcel);
        }

        /* JADX WARN: Can't rename method to resolve collision */
        @Override // android.os.Parcelable.Creator
        public KeyWordSearchModel[] newArray(int i) {
            return new KeyWordSearchModel[i];
        }
    }

    public KeyWordSearchModel(int i, String str) {
        this.sortrule = 0;
        this.isRecommend = false;
        setSearchType(i);
        setKeywords(str);
        setProtocolID(30300);
    }

    @Override // com.autonavi.amapauto.protocol.model.client.search.SearchBaseModel, com.autonavi.amapauto.protocol.model.base.ProtocolBaseModel, android.os.Parcelable
    public int describeContents() {
        return 0;
    }

    public String getCity() {
        return this.city;
    }

    public boolean getIsRecommend() {
        return this.isRecommend;
    }

    @Override // com.autonavi.amapauto.protocol.model.client.search.SearchBaseModel, com.autonavi.amapauto.protocol.model.base.ProtocolBaseModel
    public int getModelVersion() {
        return 4;
    }

    public int getSortrule() {
        return this.sortrule;
    }

    public void setCity(String str) {
        this.city = str;
    }

    public void setIsRecommend(boolean z) {
        this.isRecommend = z;
    }

    public void setSortrule(int i) {
        this.sortrule = i;
    }

    @Override // com.autonavi.amapauto.protocol.model.client.search.SearchBaseModel
    public String toString() {
        return "KeyWordSearchModel{city='" + this.city + "'}" + super.toString();
    }

    @Override // com.autonavi.amapauto.protocol.model.client.search.SearchBaseModel, com.autonavi.amapauto.protocol.model.base.ProtocolBaseModel, android.os.Parcelable
    public void writeToParcel(Parcel parcel, int i) {
        super.writeToParcel(parcel, i);
        parcel.writeString(this.city);
        if (getDataVersion() >= 3) {
            parcel.writeInt(this.sortrule);
        }
        if (getDataVersion() >= 4) {
            parcel.writeByte(this.isRecommend ? (byte) 1 : (byte) 0);
        }
    }

    public KeyWordSearchModel(Parcel parcel) {
        super(parcel);
        this.sortrule = 0;
        this.isRecommend = false;
        this.city = parcel.readString();
        if (getDataVersion() >= 3) {
            this.sortrule = parcel.readInt();
        }
        if (getDataVersion() >= 4) {
            this.isRecommend = parcel.readByte() != 0;
        }
    }
}
