package com.autonavi.amapauto.protocol.model.client.search;

import com.autonavi.amapauto.protocol.constant.StandardProtocolKey;
import java.io.Serializable;
import org.json.JSONObject;

/* loaded from: classes.dex */
public final class KeyWordSearchModel_JsonLubeParser implements Serializable {
    public static KeyWordSearchModel parse(JSONObject jSONObject) {
        if (jSONObject == null) {
            return null;
        }
        KeyWordSearchModel keyWordSearchModel = new KeyWordSearchModel(0, "");
        keyWordSearchModel.setClientPackageName(jSONObject.optString("clientPackageName", keyWordSearchModel.getClientPackageName()));
        keyWordSearchModel.setPackageName(jSONObject.optString("packageName", keyWordSearchModel.getPackageName()));
        keyWordSearchModel.setCallbackId(jSONObject.optInt("callbackId", keyWordSearchModel.getCallbackId()));
        keyWordSearchModel.setTimeStamp(jSONObject.optLong("timeStamp", keyWordSearchModel.getTimeStamp()));
        keyWordSearchModel.setVar1(jSONObject.optString("var1", keyWordSearchModel.getVar1()));
        keyWordSearchModel.setSearchType(jSONObject.optInt("searchType", keyWordSearchModel.getSearchType()));
        keyWordSearchModel.setKeywords(jSONObject.optString("keywords", keyWordSearchModel.getKeywords()));
        keyWordSearchModel.setMylocLon(jSONObject.optDouble("mylocLon", keyWordSearchModel.getMylocLon()));
        keyWordSearchModel.setMylocLat(jSONObject.optDouble("mylocLat", keyWordSearchModel.getMylocLat()));
        keyWordSearchModel.setMaxMount(jSONObject.optInt("maxCount", keyWordSearchModel.getMaxMount()));
        keyWordSearchModel.setDev(jSONObject.optInt("dev", keyWordSearchModel.getDev()));
        keyWordSearchModel.setNeedClassify(jSONObject.optInt("needClassify", keyWordSearchModel.getNeedClassify()));
        keyWordSearchModel.setNeedSort(jSONObject.optInt("needSort", keyWordSearchModel.getNeedSort()));
        keyWordSearchModel.setNeedRange(jSONObject.optInt("needRange", keyWordSearchModel.getNeedRange()));
        keyWordSearchModel.setNeedCharge(jSONObject.optInt("needCharge", keyWordSearchModel.getNeedCharge()));
        keyWordSearchModel.setNeedChildPoi(jSONObject.optInt("needChildPoi", keyWordSearchModel.getNeedChildPoi()));
        keyWordSearchModel.setClassify(jSONObject.optString("classify", keyWordSearchModel.getClassify()));
        keyWordSearchModel.setSort(jSONObject.optString("sort", keyWordSearchModel.getSort()));
        keyWordSearchModel.setRange(jSONObject.optString("range", keyWordSearchModel.getRange()));
        keyWordSearchModel.setCharge(jSONObject.optString("charge", keyWordSearchModel.getCharge()));
        keyWordSearchModel.setRequestType(jSONObject.optInt(StandardProtocolKey.EXTRA_REQUESTTYPE, keyWordSearchModel.getRequestType()));
        keyWordSearchModel.setCity(jSONObject.optString("city", keyWordSearchModel.getCity()));
        keyWordSearchModel.setSortrule(jSONObject.optInt("sortrule", keyWordSearchModel.getSortrule()));
        keyWordSearchModel.setIsRecommend(jSONObject.optBoolean("isRecommend", keyWordSearchModel.getIsRecommend()));
        return keyWordSearchModel;
    }
}
