package com.autonavi.amapauto.protocol.model.client.search;

import com.autonavi.amapauto.protocol.constant.StandardProtocolKey;
import java.io.Serializable;
import org.json.JSONException;
import org.json.JSONObject;

/* loaded from: classes.dex */
public final class KeyWordSearchModel_JsonLubeSerializer implements Serializable {
    public static JSONObject serialize(KeyWordSearchModel keyWordSearchModel) throws JSONException {
        if (keyWordSearchModel == null) {
            return null;
        }
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("packageName", keyWordSearchModel.getPackageName());
        jSONObject.put("clientPackageName", keyWordSearchModel.getClientPackageName());
        jSONObject.put("callbackId", keyWordSearchModel.getCallbackId());
        jSONObject.put("timeStamp", keyWordSearchModel.getTimeStamp());
        jSONObject.put("var1", keyWordSearchModel.getVar1());
        jSONObject.put("searchType", keyWordSearchModel.getSearchType());
        jSONObject.put("keywords", keyWordSearchModel.getKeywords());
        jSONObject.put("mylocLon", keyWordSearchModel.getMylocLon());
        jSONObject.put("mylocLat", keyWordSearchModel.getMylocLat());
        jSONObject.put("maxCount", keyWordSearchModel.getMaxMount());
        jSONObject.put("dev", keyWordSearchModel.getDev());
        jSONObject.put("needClassify", keyWordSearchModel.getNeedClassify());
        jSONObject.put("needSort", keyWordSearchModel.getNeedSort());
        jSONObject.put("needRange", keyWordSearchModel.getNeedRange());
        jSONObject.put("needCharge", keyWordSearchModel.getNeedCharge());
        jSONObject.put("needChildPoi", keyWordSearchModel.getNeedChildPoi());
        jSONObject.put("classify", keyWordSearchModel.getClassify());
        jSONObject.put("sort", keyWordSearchModel.getSort());
        jSONObject.put("range", keyWordSearchModel.getRange());
        jSONObject.put("charge", keyWordSearchModel.getCharge());
        jSONObject.put(StandardProtocolKey.EXTRA_REQUESTTYPE, keyWordSearchModel.getRequestType());
        jSONObject.put("city", keyWordSearchModel.getCity());
        jSONObject.put("sortrule", keyWordSearchModel.getSortrule());
        jSONObject.put("isRecommend", keyWordSearchModel.getIsRecommend());
        return jSONObject;
    }
}
