package com.autonavi.amapauto.protocol.model.client.search;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.Keep;
import com.autonavi.amapauto.protocol.model.base.ProtocolBaseModel;
import defpackage.o60;

@Keep
/* loaded from: classes.dex */
public class SearchBaseModel extends ProtocolBaseModel {
    public static final Parcelable.Creator<SearchBaseModel> CREATOR = new a();

    @o60
    public String charge;

    @o60(isMustFill = true)
    public String classify;

    @o60(maxValue = 1, minValue = 0)
    public int dev;

    @o60(isMustFill = true)
    public String keywords;
    public int maxMount;

    @o60(isLonLat = true)
    public double mylocLat;

    @o60(isLonLat = true)
    public double mylocLon;

    @o60(maxValue = 1, minValue = 0)
    public int needCharge;

    @o60(isMustFill = true, maxValue = 1, minValue = 0)
    public int needChildPoi;

    @o60(isMustFill = true, maxValue = 1, minValue = 0)
    public int needClassify;

    @o60(isMustFill = true, maxValue = 1, minValue = 0)
    public int needRange;

    @o60(isMustFill = true, maxValue = 1, minValue = 0)
    public int needSort;

    @o60(isMustFill = true, maxValue = 50000, minValue = 1)
    public String range;
    public int requestType;

    @o60(isMustFill = true, maxValue = 1, minValue = 0)
    public int searchType;

    @o60(isMustFill = true, maxValue = 1, minValue = 0)
    public String sort;

    /* loaded from: classes.dex */
    public static class a implements Parcelable.Creator<SearchBaseModel> {
        /* JADX WARN: Can't rename method to resolve collision */
        @Override // android.os.Parcelable.Creator
        public SearchBaseModel createFromParcel(Parcel parcel) {
            return new SearchBaseModel(parcel);
        }

        /* JADX WARN: Can't rename method to resolve collision */
        @Override // android.os.Parcelable.Creator
        public SearchBaseModel[] newArray(int i) {
            return new SearchBaseModel[i];
        }
    }

    public SearchBaseModel() {
        this.maxMount = 10;
        this.dev = 0;
    }

    @Override // com.autonavi.amapauto.protocol.model.base.ProtocolBaseModel, android.os.Parcelable
    public int describeContents() {
        return 0;
    }

    public String getCharge() {
        return this.charge;
    }

    public String getClassify() {
        return this.classify;
    }

    public int getDev() {
        return this.dev;
    }

    public String getKeywords() {
        return this.keywords;
    }

    public int getMaxMount() {
        return this.maxMount;
    }

    @Override // com.autonavi.amapauto.protocol.model.base.ProtocolBaseModel
    public int getModelVersion() {
        return 4;
    }

    public double getMylocLat() {
        return this.mylocLat;
    }

    public double getMylocLon() {
        return this.mylocLon;
    }

    public int getNeedCharge() {
        return this.needCharge;
    }

    public int getNeedChildPoi() {
        return this.needChildPoi;
    }

    public int getNeedClassify() {
        return this.needClassify;
    }

    public int getNeedRange() {
        return this.needRange;
    }

    public int getNeedSort() {
        return this.needSort;
    }

    public String getRange() {
        return this.range;
    }

    public int getRequestType() {
        return this.requestType;
    }

    public int getSearchType() {
        return this.searchType;
    }

    public String getSort() {
        return this.sort;
    }

    public void setCharge(String str) {
        this.charge = str;
    }

    public void setClassify(String str) {
        this.classify = str;
    }

    public void setDev(int i) {
        this.dev = i;
    }

    public void setKeywords(String str) {
        this.keywords = str;
    }

    public void setMaxMount(int i) {
        this.maxMount = i;
    }

    public void setMylocLat(double d) {
        this.mylocLat = d;
    }

    public void setMylocLon(double d) {
        this.mylocLon = d;
    }

    public void setNeedCharge(int i) {
        this.needCharge = i;
    }

    public void setNeedChildPoi(int i) {
        this.needChildPoi = i;
    }

    public void setNeedClassify(int i) {
        this.needClassify = i;
    }

    public void setNeedRange(int i) {
        this.needRange = i;
    }

    public void setNeedSort(int i) {
        this.needSort = i;
    }

    public void setRange(String str) {
        this.range = str;
    }

    public void setRequestType(int i) {
        this.requestType = i;
    }

    public void setSearchType(int i) {
        this.searchType = i;
    }

    public void setSort(String str) {
        this.sort = str;
    }

    public String toString() {
        return "SearchBaseModel{searchType=" + this.searchType + ", keywords='" + this.keywords + "', mylocLon=" + this.mylocLon + ", mylocLat=" + this.mylocLat + ", maxMount=" + this.maxMount + ", dev=" + this.dev + ", needClassify=" + this.needClassify + ", needSort=" + this.needSort + ", needRange=" + this.needRange + ", needCharge=" + this.needCharge + ", needChildPoi=" + this.needChildPoi + ", classify='" + this.classify + "', sort='" + this.sort + "', range='" + this.range + "', charge='" + this.charge + "'}";
    }

    @Override // com.autonavi.amapauto.protocol.model.base.ProtocolBaseModel, android.os.Parcelable
    public void writeToParcel(Parcel parcel, int i) {
        super.writeToParcel(parcel, i);
        parcel.writeInt(this.searchType);
        parcel.writeString(this.keywords);
        parcel.writeDouble(this.mylocLon);
        parcel.writeDouble(this.mylocLat);
        parcel.writeInt(this.maxMount);
        parcel.writeInt(this.dev);
        if (getDataVersion() >= 1) {
            parcel.writeInt(this.needClassify);
            parcel.writeInt(this.needSort);
            parcel.writeInt(this.needRange);
            parcel.writeInt(this.needCharge);
            parcel.writeInt(this.needChildPoi);
            parcel.writeString(this.classify);
            parcel.writeString(this.sort);
            parcel.writeString(this.range);
            parcel.writeString(this.charge);
        }
        if (getDataVersion() >= 2) {
            parcel.writeInt(this.requestType);
        }
    }

    public SearchBaseModel(Parcel parcel) {
        super(parcel);
        this.maxMount = 10;
        this.dev = 0;
        this.searchType = parcel.readInt();
        this.keywords = parcel.readString();
        this.mylocLon = parcel.readDouble();
        this.mylocLat = parcel.readDouble();
        this.maxMount = parcel.readInt();
        this.dev = parcel.readInt();
        if (getDataVersion() >= 1) {
            this.needClassify = parcel.readInt();
            this.needSort = parcel.readInt();
            this.needRange = parcel.readInt();
            this.needCharge = parcel.readInt();
            this.needChildPoi = parcel.readInt();
            this.classify = parcel.readString();
            this.sort = parcel.readString();
            this.range = parcel.readString();
            this.charge = parcel.readString();
        }
        if (getDataVersion() >= 2) {
            this.requestType = parcel.readInt();
        }
    }
}
