package com.autonavi.amapauto.protocol.model.client.search;

import com.autonavi.amapauto.protocol.constant.StandardProtocolKey;
import java.io.Serializable;
import org.json.JSONObject;

/* loaded from: classes.dex */
public final class SearchBaseModel_JsonLubeParser implements Serializable {
    public static SearchBaseModel parse(JSONObject jSONObject) {
        if (jSONObject == null) {
            return null;
        }
        SearchBaseModel searchBaseModel = new SearchBaseModel();
        searchBaseModel.setClientPackageName(jSONObject.optString("clientPackageName", searchBaseModel.getClientPackageName()));
        searchBaseModel.setPackageName(jSONObject.optString("packageName", searchBaseModel.getPackageName()));
        searchBaseModel.setCallbackId(jSONObject.optInt("callbackId", searchBaseModel.getCallbackId()));
        searchBaseModel.setTimeStamp(jSONObject.optLong("timeStamp", searchBaseModel.getTimeStamp()));
        searchBaseModel.setVar1(jSONObject.optString("var1", searchBaseModel.getVar1()));
        searchBaseModel.setSearchType(jSONObject.optInt("searchType", searchBaseModel.getSearchType()));
        searchBaseModel.setKeywords(jSONObject.optString("keywords", searchBaseModel.getKeywords()));
        searchBaseModel.setMylocLon(jSONObject.optDouble("mylocLon", searchBaseModel.getMylocLon()));
        searchBaseModel.setMylocLat(jSONObject.optDouble("mylocLat", searchBaseModel.getMylocLat()));
        searchBaseModel.setMaxMount(jSONObject.optInt("maxCount", searchBaseModel.getMaxMount()));
        searchBaseModel.setDev(jSONObject.optInt("dev", searchBaseModel.getDev()));
        searchBaseModel.setNeedClassify(jSONObject.optInt("needClassify", searchBaseModel.getNeedClassify()));
        searchBaseModel.setNeedSort(jSONObject.optInt("needSort", searchBaseModel.getNeedSort()));
        searchBaseModel.setNeedRange(jSONObject.optInt("needRange", searchBaseModel.getNeedRange()));
        searchBaseModel.setNeedCharge(jSONObject.optInt("needCharge", searchBaseModel.getNeedCharge()));
        searchBaseModel.setNeedChildPoi(jSONObject.optInt("needChildPoi", searchBaseModel.getNeedChildPoi()));
        searchBaseModel.setClassify(jSONObject.optString("classify", searchBaseModel.getClassify()));
        searchBaseModel.setSort(jSONObject.optString("sort", searchBaseModel.getSort()));
        searchBaseModel.setRange(jSONObject.optString("range", searchBaseModel.getRange()));
        searchBaseModel.setCharge(jSONObject.optString("charge", searchBaseModel.getCharge()));
        searchBaseModel.setRequestType(jSONObject.optInt(StandardProtocolKey.EXTRA_REQUESTTYPE, searchBaseModel.getRequestType()));
        return searchBaseModel;
    }
}
