package com.autonavi.amapauto.protocol.model.client.search;

import com.autonavi.amapauto.protocol.constant.StandardProtocolKey;
import java.io.Serializable;
import org.json.JSONException;
import org.json.JSONObject;

/* loaded from: classes.dex */
public final class SearchBaseModel_JsonLubeSerializer implements Serializable {
    public static JSONObject serialize(SearchBaseModel searchBaseModel) throws JSONException {
        if (searchBaseModel == null) {
            return null;
        }
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("packageName", searchBaseModel.getPackageName());
        jSONObject.put("clientPackageName", searchBaseModel.getClientPackageName());
        jSONObject.put("callbackId", searchBaseModel.getCallbackId());
        jSONObject.put("timeStamp", searchBaseModel.getTimeStamp());
        jSONObject.put("var1", searchBaseModel.getVar1());
        jSONObject.put("searchType", searchBaseModel.getSearchType());
        jSONObject.put("keywords", searchBaseModel.getKeywords());
        jSONObject.put("mylocLon", searchBaseModel.getMylocLon());
        jSONObject.put("mylocLat", searchBaseModel.getMylocLat());
        jSONObject.put("maxCount", searchBaseModel.getMaxMount());
        jSONObject.put("dev", searchBaseModel.getDev());
        jSONObject.put("needClassify", searchBaseModel.getNeedClassify());
        jSONObject.put("needSort", searchBaseModel.getNeedSort());
        jSONObject.put("needRange", searchBaseModel.getNeedRange());
        jSONObject.put("needCharge", searchBaseModel.getNeedCharge());
        jSONObject.put("needChildPoi", searchBaseModel.getNeedChildPoi());
        jSONObject.put("classify", searchBaseModel.getClassify());
        jSONObject.put("sort", searchBaseModel.getSort());
        jSONObject.put("range", searchBaseModel.getRange());
        jSONObject.put("charge", searchBaseModel.getCharge());
        jSONObject.put(StandardProtocolKey.EXTRA_REQUESTTYPE, searchBaseModel.getRequestType());
        return jSONObject;
    }
}
