package com.autonavi.amapauto.protocol.model.client.user;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.Keep;
import com.autonavi.amapauto.protocol.model.base.ProtocolBaseModel;

@Keep
/* loaded from: classes.dex */
public class FavoriteCurrentPoiModel extends ProtocolBaseModel {
    public static final Parcelable.Creator<FavoriteCurrentPoiModel> CREATOR = new a();
    public String addr;
    public int isFavoriteSuccess;
    public double lat;
    public double lon;
    public String phone;
    public String poiId;
    public String poiName;

    /* loaded from: classes.dex */
    public static class a implements Parcelable.Creator<FavoriteCurrentPoiModel> {
        /* JADX WARN: Can't rename method to resolve collision */
        @Override // android.os.Parcelable.Creator
        public FavoriteCurrentPoiModel createFromParcel(Parcel parcel) {
            return new FavoriteCurrentPoiModel(parcel);
        }

        /* JADX WARN: Can't rename method to resolve collision */
        @Override // android.os.Parcelable.Creator
        public FavoriteCurrentPoiModel[] newArray(int i) {
            return new FavoriteCurrentPoiModel[i];
        }
    }

    public FavoriteCurrentPoiModel() {
        setProtocolID(30004);
    }

    @Override // com.autonavi.amapauto.protocol.model.base.ProtocolBaseModel, android.os.Parcelable
    public int describeContents() {
        return 0;
    }

    public String getAddr() {
        return this.addr;
    }

    public int getIsFavoriteSuccess() {
        return this.isFavoriteSuccess;
    }

    public double getLat() {
        return this.lat;
    }

    public double getLon() {
        return this.lon;
    }

    @Override // com.autonavi.amapauto.protocol.model.base.ProtocolBaseModel
    public int getModelVersion() {
        return 1;
    }

    public String getPhone() {
        return this.phone;
    }

    public String getPoiId() {
        return this.poiId;
    }

    public String getPoiName() {
        return this.poiName;
    }

    public void setAddr(String str) {
        this.addr = str;
    }

    public void setIsFavoriteSuccess(int i) {
        this.isFavoriteSuccess = i;
    }

    public void setLat(double d) {
        this.lat = d;
    }

    public void setLon(double d) {
        this.lon = d;
    }

    public void setPhone(String str) {
        this.phone = str;
    }

    public void setPoiId(String str) {
        this.poiId = str;
    }

    public void setPoiName(String str) {
        this.poiName = str;
    }

    @Override // com.autonavi.amapauto.protocol.model.base.ProtocolBaseModel, android.os.Parcelable
    public void writeToParcel(Parcel parcel, int i) {
        super.writeToParcel(parcel, i);
        parcel.writeInt(this.isFavoriteSuccess);
        if (getDataVersion() >= 1) {
            parcel.writeString(this.poiId);
            parcel.writeString(this.poiName);
            parcel.writeString(this.addr);
            parcel.writeString(this.phone);
            parcel.writeDouble(this.lat);
            parcel.writeDouble(this.lon);
        }
    }

    public FavoriteCurrentPoiModel(Parcel parcel) {
        super(parcel);
        this.isFavoriteSuccess = parcel.readInt();
        if (getDataVersion() >= 1) {
            this.poiId = parcel.readString();
            this.poiName = parcel.readString();
            this.addr = parcel.readString();
            this.phone = parcel.readString();
            this.lat = parcel.readDouble();
            this.lon = parcel.readDouble();
        }
    }
}
