package com.autonavi.amapauto.protocol.model.client.user;

import com.amap.location.sdk.fusion.LocationParams;
import com.autonavi.amapauto.protocol.constant.StandardProtocolKey;
import java.io.Serializable;
import org.json.JSONObject;

/* loaded from: classes.dex */
public final class FavoriteCurrentPoiModel_JsonLubeParser implements Serializable {
    public static FavoriteCurrentPoiModel parse(JSONObject jSONObject) {
        if (jSONObject == null) {
            return null;
        }
        FavoriteCurrentPoiModel favoriteCurrentPoiModel = new FavoriteCurrentPoiModel();
        favoriteCurrentPoiModel.poiId = jSONObject.optString(StandardProtocolKey.POI_ID, favoriteCurrentPoiModel.poiId);
        favoriteCurrentPoiModel.poiName = jSONObject.optString(StandardProtocolKey.EXTRA_POINAME, favoriteCurrentPoiModel.poiName);
        favoriteCurrentPoiModel.addr = jSONObject.optString(StandardProtocolKey.POI_ADDR, favoriteCurrentPoiModel.addr);
        favoriteCurrentPoiModel.phone = jSONObject.optString(StandardProtocolKey.PHONE, favoriteCurrentPoiModel.phone);
        favoriteCurrentPoiModel.lat = jSONObject.optDouble(LocationParams.PARA_FLP_AUTONAVI_LAT, favoriteCurrentPoiModel.lat);
        favoriteCurrentPoiModel.lon = jSONObject.optDouble(LocationParams.PARA_FLP_AUTONAVI_LON, favoriteCurrentPoiModel.lon);
        favoriteCurrentPoiModel.setClientPackageName(jSONObject.optString("clientPackageName", favoriteCurrentPoiModel.getClientPackageName()));
        favoriteCurrentPoiModel.setPackageName(jSONObject.optString("packageName", favoriteCurrentPoiModel.getPackageName()));
        favoriteCurrentPoiModel.setCallbackId(jSONObject.optInt("callbackId", favoriteCurrentPoiModel.getCallbackId()));
        favoriteCurrentPoiModel.setTimeStamp(jSONObject.optLong("timeStamp", favoriteCurrentPoiModel.getTimeStamp()));
        favoriteCurrentPoiModel.setVar1(jSONObject.optString("var1", favoriteCurrentPoiModel.getVar1()));
        favoriteCurrentPoiModel.setIsFavoriteSuccess(jSONObject.optInt("isFavoriteSuccess", favoriteCurrentPoiModel.getIsFavoriteSuccess()));
        return favoriteCurrentPoiModel;
    }
}
