package com.autonavi.amapauto.protocol.model.client.user;

import com.amap.location.sdk.fusion.LocationParams;
import com.autonavi.amapauto.protocol.constant.StandardProtocolKey;
import java.io.Serializable;
import org.json.JSONException;
import org.json.JSONObject;

/* loaded from: classes.dex */
public final class FavoriteCurrentPoiModel_JsonLubeSerializer implements Serializable {
    public static JSONObject serialize(FavoriteCurrentPoiModel favoriteCurrentPoiModel) throws JSONException {
        if (favoriteCurrentPoiModel == null) {
            return null;
        }
        JSONObject jSONObject = new JSONObject();
        jSONObject.put(StandardProtocolKey.POI_ID, favoriteCurrentPoiModel.poiId);
        jSONObject.put(StandardProtocolKey.EXTRA_POINAME, favoriteCurrentPoiModel.poiName);
        jSONObject.put(StandardProtocolKey.POI_ADDR, favoriteCurrentPoiModel.addr);
        jSONObject.put(StandardProtocolKey.PHONE, favoriteCurrentPoiModel.phone);
        jSONObject.put(LocationParams.PARA_FLP_AUTONAVI_LAT, favoriteCurrentPoiModel.lat);
        jSONObject.put(LocationParams.PARA_FLP_AUTONAVI_LON, favoriteCurrentPoiModel.lon);
        jSONObject.put("packageName", favoriteCurrentPoiModel.getPackageName());
        jSONObject.put("clientPackageName", favoriteCurrentPoiModel.getClientPackageName());
        jSONObject.put("callbackId", favoriteCurrentPoiModel.getCallbackId());
        jSONObject.put("timeStamp", favoriteCurrentPoiModel.getTimeStamp());
        jSONObject.put("var1", favoriteCurrentPoiModel.getVar1());
        jSONObject.put("isFavoriteSuccess", favoriteCurrentPoiModel.getIsFavoriteSuccess());
        return jSONObject;
    }
}
