package com.autonavi.amapauto.protocol.model.client.user;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.Keep;
import com.autonavi.amapauto.protocol.model.base.ProtocolBaseModel;
import defpackage.o60;

@Keep
/* loaded from: classes.dex */
public class RequestFavoritePoiModel extends ProtocolBaseModel {
    public static final Parcelable.Creator<RequestFavoritePoiModel> CREATOR = new a();
    public double entryLat;
    public double entryLon;

    @o60(isMustFill = true, maxValue = 2, minValue = 0)
    public int favoriteType;
    public boolean isDev;

    @o60(isLonLat = true, isMustFill = true)
    public double latitude;

    @o60(isLonLat = true, isMustFill = true)
    public double longitude;
    public String poiAddress;
    public String poiId;
    public String poiName;
    public String poiType;

    /* loaded from: classes.dex */
    public static class a implements Parcelable.Creator<RequestFavoritePoiModel> {
        /* JADX WARN: Can't rename method to resolve collision */
        @Override // android.os.Parcelable.Creator
        public RequestFavoritePoiModel createFromParcel(Parcel parcel) {
            return new RequestFavoritePoiModel(parcel);
        }

        /* JADX WARN: Can't rename method to resolve collision */
        @Override // android.os.Parcelable.Creator
        public RequestFavoritePoiModel[] newArray(int i) {
            return new RequestFavoritePoiModel[i];
        }
    }

    public RequestFavoritePoiModel(int i, double d, double d2) {
        setProtocolID(30509);
        this.favoriteType = i;
        this.longitude = d;
        this.latitude = d2;
    }

    @Override // com.autonavi.amapauto.protocol.model.base.ProtocolBaseModel, android.os.Parcelable
    public int describeContents() {
        return 0;
    }

    public double getEntryLat() {
        return this.entryLat;
    }

    public double getEntryLon() {
        return this.entryLon;
    }

    public int getFavoriteType() {
        return this.favoriteType;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public String getPoiAddress() {
        return this.poiAddress;
    }

    public String getPoiId() {
        return this.poiId;
    }

    public String getPoiName() {
        return this.poiName;
    }

    public String getPoiType() {
        return this.poiType;
    }

    public boolean isDev() {
        return this.isDev;
    }

    public void setDev(boolean z) {
        this.isDev = z;
    }

    public void setEntryLat(double d) {
        this.entryLat = d;
    }

    public void setEntryLon(double d) {
        this.entryLon = d;
    }

    public void setFavoriteType(int i) {
        this.favoriteType = i;
    }

    public void setLatitude(double d) {
        this.latitude = d;
    }

    public void setLongitude(double d) {
        this.longitude = d;
    }

    public void setPoiAddress(String str) {
        this.poiAddress = str;
    }

    public void setPoiId(String str) {
        this.poiId = str;
    }

    public void setPoiName(String str) {
        this.poiName = str;
    }

    public void setPoiType(String str) {
        this.poiType = str;
    }

    @Override // com.autonavi.amapauto.protocol.model.base.ProtocolBaseModel, android.os.Parcelable
    public void writeToParcel(Parcel parcel, int i) {
        super.writeToParcel(parcel, i);
        parcel.writeInt(this.favoriteType);
        parcel.writeString(this.poiName);
        parcel.writeDouble(this.longitude);
        parcel.writeDouble(this.latitude);
        parcel.writeDouble(this.entryLon);
        parcel.writeDouble(this.entryLat);
        parcel.writeString(this.poiAddress);
        parcel.writeByte(this.isDev ? (byte) 1 : (byte) 0);
        parcel.writeString(this.poiType);
        parcel.writeString(this.poiId);
    }

    public RequestFavoritePoiModel(Parcel parcel) {
        super(parcel);
        this.favoriteType = parcel.readInt();
        this.poiName = parcel.readString();
        this.longitude = parcel.readDouble();
        this.latitude = parcel.readDouble();
        this.entryLon = parcel.readDouble();
        this.entryLat = parcel.readDouble();
        this.poiAddress = parcel.readString();
        this.isDev = parcel.readByte() != 0;
        this.poiType = parcel.readString();
        this.poiId = parcel.readString();
    }
}
