package com.autonavi.amapauto.protocol.model.client.user;

import com.autonavi.amapauto.protocol.constant.StandardProtocolKey;
import java.io.Serializable;
import org.json.JSONException;
import org.json.JSONObject;

/* loaded from: classes.dex */
public final class RequestFavoritePoiModel_JsonLubeSerializer implements Serializable {
    public static JSONObject serialize(RequestFavoritePoiModel requestFavoritePoiModel) throws JSONException {
        if (requestFavoritePoiModel == null) {
            return null;
        }
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("packageName", requestFavoritePoiModel.getPackageName());
        jSONObject.put("clientPackageName", requestFavoritePoiModel.getClientPackageName());
        jSONObject.put("callbackId", requestFavoritePoiModel.getCallbackId());
        jSONObject.put("timeStamp", requestFavoritePoiModel.getTimeStamp());
        jSONObject.put("var1", requestFavoritePoiModel.getVar1());
        jSONObject.put("favoriteType", requestFavoritePoiModel.getFavoriteType());
        jSONObject.put(StandardProtocolKey.EXTRA_POINAME, requestFavoritePoiModel.getPoiName());
        jSONObject.put("longitude", requestFavoritePoiModel.getLongitude());
        jSONObject.put("latitude", requestFavoritePoiModel.getLatitude());
        jSONObject.put("entryLon", requestFavoritePoiModel.getEntryLon());
        jSONObject.put("entryLat", requestFavoritePoiModel.getEntryLat());
        jSONObject.put("poiAddress", requestFavoritePoiModel.getPoiAddress());
        jSONObject.put("isDev", requestFavoritePoiModel.isDev());
        jSONObject.put("poiType", requestFavoritePoiModel.getPoiType());
        jSONObject.put(StandardProtocolKey.POI_ID, requestFavoritePoiModel.getPoiId());
        return jSONObject;
    }
}
