package com.autonavi.amapauto.protocol.model.item;

import com.amap.location.sdk.fusion.LocationParams;
import com.autonavi.amapauto.protocol.constant.StandardProtocolKey;
import java.io.Serializable;
import org.json.JSONObject;

/* loaded from: classes.dex */
public final class FavoritePoiInfo_JsonLubeParser implements Serializable {
    public static FavoritePoiInfo parse(JSONObject jSONObject) {
        if (jSONObject == null) {
            return null;
        }
        FavoritePoiInfo favoritePoiInfo = new FavoritePoiInfo();
        favoritePoiInfo.setClientPackageName(jSONObject.optString("clientPackageName", favoritePoiInfo.getClientPackageName()));
        favoritePoiInfo.setPackageName(jSONObject.optString("packageName", favoritePoiInfo.getPackageName()));
        favoritePoiInfo.setCallbackId(jSONObject.optInt("callbackId", favoritePoiInfo.getCallbackId()));
        favoritePoiInfo.setTimeStamp(jSONObject.optLong("timeStamp", favoritePoiInfo.getTimeStamp()));
        favoritePoiInfo.setVar1(jSONObject.optString("var1", favoritePoiInfo.getVar1()));
        favoritePoiInfo.setLat(jSONObject.optDouble(LocationParams.PARA_FLP_AUTONAVI_LAT, favoritePoiInfo.getLat()));
        favoritePoiInfo.setLon(jSONObject.optDouble(LocationParams.PARA_FLP_AUTONAVI_LON, favoritePoiInfo.getLon()));
        favoritePoiInfo.a(jSONObject.optDouble("entry_lat", favoritePoiInfo.o()));
        favoritePoiInfo.b(jSONObject.optDouble("entry_lon", favoritePoiInfo.p()));
        favoritePoiInfo.c(jSONObject.optInt(StandardProtocolKey.POIDEEPINFO_CATEGORY, favoritePoiInfo.n()));
        favoritePoiInfo.e(jSONObject.optInt("poiType", favoritePoiInfo.getPoiType()));
        favoritePoiInfo.b(jSONObject.optString("version", favoritePoiInfo.s()));
        favoritePoiInfo.setFavoriteType(jSONObject.optInt("favoriteType", favoritePoiInfo.getFavoriteType()));
        favoritePoiInfo.setPoiId(jSONObject.optString(StandardProtocolKey.POI_ID, favoritePoiInfo.getPoiId()));
        favoritePoiInfo.a(jSONObject.optString("favoritePoiName", favoritePoiInfo.q()));
        favoritePoiInfo.setPoiAddress(jSONObject.optString("poiAddress", favoritePoiInfo.getPoiAddress()));
        favoritePoiInfo.d(jSONObject.optInt("poiDistance", favoritePoiInfo.r()));
        return favoritePoiInfo;
    }
}
