package com.autonavi.amapauto.protocol.model.item;

import com.amap.location.sdk.fusion.LocationParams;
import com.autonavi.amapauto.protocol.constant.StandardProtocolKey;
import java.io.Serializable;
import org.json.JSONException;
import org.json.JSONObject;

/* loaded from: classes.dex */
public final class FavoritePoiInfo_JsonLubeSerializer implements Serializable {
    public static JSONObject serialize(FavoritePoiInfo favoritePoiInfo) throws JSONException {
        if (favoritePoiInfo == null) {
            return null;
        }
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("packageName", favoritePoiInfo.getPackageName());
        jSONObject.put("clientPackageName", favoritePoiInfo.getClientPackageName());
        jSONObject.put("callbackId", favoritePoiInfo.getCallbackId());
        jSONObject.put("timeStamp", favoritePoiInfo.getTimeStamp());
        jSONObject.put("var1", favoritePoiInfo.getVar1());
        jSONObject.put(LocationParams.PARA_FLP_AUTONAVI_LAT, favoritePoiInfo.getLat());
        jSONObject.put(LocationParams.PARA_FLP_AUTONAVI_LON, favoritePoiInfo.getLon());
        jSONObject.put("entry_lat", favoritePoiInfo.o());
        jSONObject.put("entry_lon", favoritePoiInfo.p());
        jSONObject.put(StandardProtocolKey.POIDEEPINFO_CATEGORY, favoritePoiInfo.n());
        jSONObject.put("poiType", favoritePoiInfo.getPoiType());
        jSONObject.put("version", favoritePoiInfo.s());
        jSONObject.put("favoriteType", favoritePoiInfo.getFavoriteType());
        jSONObject.put(StandardProtocolKey.POI_ID, favoritePoiInfo.getPoiId());
        jSONObject.put("favoritePoiName", favoritePoiInfo.q());
        jSONObject.put("poiAddress", favoritePoiInfo.getPoiAddress());
        jSONObject.put("poiDistance", favoritePoiInfo.r());
        return jSONObject;
    }
}
