package com.autonavi.amapauto.protocol.model.item;

import com.autonavi.amapauto.protocol.constant.StandardProtocolKey;
import java.io.Serializable;
import org.json.JSONObject;

/* loaded from: classes.dex */
public final class HistoryPoiInfo_JsonLubeParser implements Serializable {
    public static HistoryPoiInfo parse(JSONObject jSONObject) {
        if (jSONObject == null) {
            return null;
        }
        HistoryPoiInfo historyPoiInfo = new HistoryPoiInfo();
        historyPoiInfo.setClientPackageName(jSONObject.optString("clientPackageName", historyPoiInfo.getClientPackageName()));
        historyPoiInfo.setPackageName(jSONObject.optString("packageName", historyPoiInfo.getPackageName()));
        historyPoiInfo.setCallbackId(jSONObject.optInt("callbackId", historyPoiInfo.getCallbackId()));
        historyPoiInfo.setTimeStamp(jSONObject.optLong("timeStamp", historyPoiInfo.getTimeStamp()));
        historyPoiInfo.setVar1(jSONObject.optString("var1", historyPoiInfo.getVar1()));
        historyPoiInfo.setPoiId(jSONObject.optString(StandardProtocolKey.POI_ID, historyPoiInfo.getPoiId()));
        historyPoiInfo.setPoiName(jSONObject.optString(StandardProtocolKey.EXTRA_POINAME, historyPoiInfo.getPoiName()));
        historyPoiInfo.setLongitude(jSONObject.optDouble("longitude", historyPoiInfo.getLongitude()));
        historyPoiInfo.setLatitude(jSONObject.optDouble("latitude", historyPoiInfo.getLatitude()));
        historyPoiInfo.setEntryLongitude(jSONObject.optDouble(StandardProtocolKey.EXTRA_ENTRYLONGITUDE, historyPoiInfo.getEntryLongitude()));
        historyPoiInfo.setEntryLatitude(jSONObject.optDouble(StandardProtocolKey.EXTRA_ENTRYLATITUDE, historyPoiInfo.getEntryLatitude()));
        historyPoiInfo.a(jSONObject.optString("typeCode", historyPoiInfo.getTypeCode()));
        historyPoiInfo.setJson(jSONObject.optString("json", historyPoiInfo.getJson()));
        historyPoiInfo.setAddress(jSONObject.optString(StandardProtocolKey.POI_ADDRESS, historyPoiInfo.getAddress()));
        historyPoiInfo.setDistance(jSONObject.optInt(StandardProtocolKey.POI_DISTANCE, historyPoiInfo.getDistance()));
        return historyPoiInfo;
    }
}
