package com.autonavi.amapauto.protocol.model.item;

import com.autonavi.amapauto.protocol.constant.StandardProtocolKey;
import java.io.Serializable;
import org.json.JSONException;
import org.json.JSONObject;

/* loaded from: classes.dex */
public final class HistoryPoiInfo_JsonLubeSerializer implements Serializable {
    public static JSONObject serialize(HistoryPoiInfo historyPoiInfo) throws JSONException {
        if (historyPoiInfo == null) {
            return null;
        }
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("packageName", historyPoiInfo.getPackageName());
        jSONObject.put("clientPackageName", historyPoiInfo.getClientPackageName());
        jSONObject.put("callbackId", historyPoiInfo.getCallbackId());
        jSONObject.put("timeStamp", historyPoiInfo.getTimeStamp());
        jSONObject.put("var1", historyPoiInfo.getVar1());
        jSONObject.put(StandardProtocolKey.POI_ID, historyPoiInfo.getPoiId());
        jSONObject.put(StandardProtocolKey.EXTRA_POINAME, historyPoiInfo.getPoiName());
        jSONObject.put("longitude", historyPoiInfo.getLongitude());
        jSONObject.put("latitude", historyPoiInfo.getLatitude());
        jSONObject.put(StandardProtocolKey.EXTRA_ENTRYLONGITUDE, historyPoiInfo.getEntryLongitude());
        jSONObject.put(StandardProtocolKey.EXTRA_ENTRYLATITUDE, historyPoiInfo.getEntryLatitude());
        jSONObject.put("typeCode", historyPoiInfo.getTypeCode());
        jSONObject.put("json", historyPoiInfo.getJson());
        jSONObject.put(StandardProtocolKey.POI_ADDRESS, historyPoiInfo.getAddress());
        jSONObject.put(StandardProtocolKey.POI_DISTANCE, historyPoiInfo.getDistance());
        return jSONObject;
    }
}
