package com.autonavi.amapauto.protocol.model.item;

import java.io.Serializable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/* loaded from: classes.dex */
public final class IconRoadInfo_JsonLubeSerializer implements Serializable {
    public static JSONObject serialize(IconRoadInfo iconRoadInfo) throws JSONException {
        if (iconRoadInfo == null) {
            return null;
        }
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("packageName", iconRoadInfo.getPackageName());
        jSONObject.put("clientPackageName", iconRoadInfo.getClientPackageName());
        jSONObject.put("callbackId", iconRoadInfo.getCallbackId());
        jSONObject.put("timeStamp", iconRoadInfo.getTimeStamp());
        jSONObject.put("var1", iconRoadInfo.getVar1());
        jSONObject.put("version", iconRoadInfo.q());
        jSONObject.put("json", iconRoadInfo.getJson());
        jSONObject.put("roadUsage", iconRoadInfo.o());
        jSONObject.put("roadType", iconRoadInfo.n());
        if (iconRoadInfo.p() != null) {
            JSONArray jSONArray = new JSONArray();
            for (int i : iconRoadInfo.p()) {
                jSONArray.put(i);
            }
            jSONObject.put("vectorPoints", jSONArray);
        }
        return jSONObject;
    }
}
