package com.autonavi.amapauto.protocol.model.item;

import com.autonavi.amapauto.protocol.constant.StandardProtocolKey;
import java.io.Serializable;
import org.json.JSONObject;

/* loaded from: classes.dex */
public final class NewFavoriteData_JsonLubeParser implements Serializable {
    public static NewFavoriteData parse(JSONObject jSONObject) {
        if (jSONObject == null) {
            return null;
        }
        NewFavoriteData newFavoriteData = new NewFavoriteData();
        newFavoriteData.setClientPackageName(jSONObject.optString("clientPackageName", newFavoriteData.getClientPackageName()));
        newFavoriteData.setPackageName(jSONObject.optString("packageName", newFavoriteData.getPackageName()));
        newFavoriteData.setCallbackId(jSONObject.optInt("callbackId", newFavoriteData.getCallbackId()));
        newFavoriteData.setTimeStamp(jSONObject.optLong("timeStamp", newFavoriteData.getTimeStamp()));
        newFavoriteData.setVar1(jSONObject.optString("var1", newFavoriteData.getVar1()));
        newFavoriteData.setAddr(jSONObject.optString(StandardProtocolKey.POI_ADDR, newFavoriteData.getAddr()));
        newFavoriteData.setDistance(jSONObject.optInt(StandardProtocolKey.POI_DISTANCE, newFavoriteData.getDistance()));
        newFavoriteData.setEntryLatitude(jSONObject.optDouble(StandardProtocolKey.EXTRA_ENTRYLATITUDE, newFavoriteData.getEntryLatitude()));
        newFavoriteData.setEntryLongitude(jSONObject.optDouble(StandardProtocolKey.EXTRA_ENTRYLONGITUDE, newFavoriteData.getEntryLongitude()));
        newFavoriteData.setLatitude(jSONObject.optDouble("latitude", newFavoriteData.getLatitude()));
        newFavoriteData.setLongitude(jSONObject.optDouble("longitude", newFavoriteData.getLongitude()));
        newFavoriteData.setName(jSONObject.optString(StandardProtocolKey.NAME, newFavoriteData.getName()));
        newFavoriteData.setPhone(jSONObject.optString(StandardProtocolKey.PHONE, newFavoriteData.getPhone()));
        newFavoriteData.setPoiId(jSONObject.optString(StandardProtocolKey.POI_ID, newFavoriteData.getPoiId()));
        newFavoriteData.d(jSONObject.optInt(StandardProtocolKey.POITYPE, newFavoriteData.getPoitype()));
        newFavoriteData.c(jSONObject.optInt("favouriteType", newFavoriteData.n()));
        return newFavoriteData;
    }
}
