package com.autonavi.amapauto.protocol.model.item;

import com.autonavi.amapauto.protocol.constant.StandardProtocolKey;
import java.io.Serializable;
import org.json.JSONException;
import org.json.JSONObject;

/* loaded from: classes.dex */
public final class NewFavoriteData_JsonLubeSerializer implements Serializable {
    public static JSONObject serialize(NewFavoriteData newFavoriteData) throws JSONException {
        if (newFavoriteData == null) {
            return null;
        }
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("packageName", newFavoriteData.getPackageName());
        jSONObject.put("clientPackageName", newFavoriteData.getClientPackageName());
        jSONObject.put("callbackId", newFavoriteData.getCallbackId());
        jSONObject.put("timeStamp", newFavoriteData.getTimeStamp());
        jSONObject.put("var1", newFavoriteData.getVar1());
        jSONObject.put(StandardProtocolKey.POI_ADDR, newFavoriteData.getAddr());
        jSONObject.put(StandardProtocolKey.POI_DISTANCE, newFavoriteData.getDistance());
        jSONObject.put(StandardProtocolKey.EXTRA_ENTRYLATITUDE, newFavoriteData.getEntryLatitude());
        jSONObject.put(StandardProtocolKey.EXTRA_ENTRYLONGITUDE, newFavoriteData.getEntryLongitude());
        jSONObject.put("latitude", newFavoriteData.getLatitude());
        jSONObject.put("longitude", newFavoriteData.getLongitude());
        jSONObject.put(StandardProtocolKey.NAME, newFavoriteData.getName());
        jSONObject.put(StandardProtocolKey.PHONE, newFavoriteData.getPhone());
        jSONObject.put(StandardProtocolKey.POI_ID, newFavoriteData.getPoiId());
        jSONObject.put(StandardProtocolKey.POITYPE, newFavoriteData.getPoitype());
        jSONObject.put("favouriteType", newFavoriteData.n());
        return jSONObject;
    }
}
