package com.autonavi.amapauto.protocol.model.item;

import com.autonavi.amapauto.protocol.constant.StandardProtocolKey;
import java.io.Serializable;
import org.json.JSONObject;

/* loaded from: classes.dex */
public final class ProtocolParkInfo_JsonLubeParser implements Serializable {
    public static ProtocolParkInfo parse(JSONObject jSONObject) {
        if (jSONObject == null) {
            return null;
        }
        ProtocolParkInfo protocolParkInfo = new ProtocolParkInfo();
        protocolParkInfo.setClientPackageName(jSONObject.optString("clientPackageName", protocolParkInfo.getClientPackageName()));
        protocolParkInfo.setPackageName(jSONObject.optString("packageName", protocolParkInfo.getPackageName()));
        protocolParkInfo.setCallbackId(jSONObject.optInt("callbackId", protocolParkInfo.getCallbackId()));
        protocolParkInfo.setTimeStamp(jSONObject.optLong("timeStamp", protocolParkInfo.getTimeStamp()));
        protocolParkInfo.setVar1(jSONObject.optString("var1", protocolParkInfo.getVar1()));
        protocolParkInfo.c(jSONObject.optInt("index", protocolParkInfo.o()));
        protocolParkInfo.setName(jSONObject.optString(StandardProtocolKey.NAME, protocolParkInfo.getName()));
        protocolParkInfo.setDistance(jSONObject.optInt(StandardProtocolKey.POI_DISTANCE, protocolParkInfo.getDistance()));
        protocolParkInfo.b(jSONObject.optString(StandardProtocolKey.POIDEEPINFO_TAGINFO_PRICE, protocolParkInfo.p()));
        protocolParkInfo.setLatitude(jSONObject.optDouble("latitude", protocolParkInfo.getLatitude()));
        protocolParkInfo.setLongitude(jSONObject.optDouble("longitude", protocolParkInfo.getLongitude()));
        protocolParkInfo.setEntry_longitude(jSONObject.optDouble(StandardProtocolKey.ENTRY_LONGITUDE, protocolParkInfo.getEntry_longitude()));
        protocolParkInfo.setEntry_latitude(jSONObject.optDouble(StandardProtocolKey.ENTRY_LATITUDE, protocolParkInfo.getEntry_latitude()));
        protocolParkInfo.a(jSONObject.optString(StandardProtocolKey.POIDEEPINFO_CATEGORY, protocolParkInfo.n()));
        protocolParkInfo.d(jSONObject.optInt("spacenum", protocolParkInfo.q()));
        protocolParkInfo.setPoiid(jSONObject.optString(StandardProtocolKey.POIID, protocolParkInfo.getPoiid()));
        return protocolParkInfo;
    }
}
