package com.autonavi.amapauto.protocol.model.item;

import com.autonavi.amapauto.protocol.constant.StandardProtocolKey;
import java.io.Serializable;
import org.json.JSONException;
import org.json.JSONObject;

/* loaded from: classes.dex */
public final class ProtocolParkInfo_JsonLubeSerializer implements Serializable {
    public static JSONObject serialize(ProtocolParkInfo protocolParkInfo) throws JSONException {
        if (protocolParkInfo == null) {
            return null;
        }
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("packageName", protocolParkInfo.getPackageName());
        jSONObject.put("clientPackageName", protocolParkInfo.getClientPackageName());
        jSONObject.put("callbackId", protocolParkInfo.getCallbackId());
        jSONObject.put("timeStamp", protocolParkInfo.getTimeStamp());
        jSONObject.put("var1", protocolParkInfo.getVar1());
        jSONObject.put("index", protocolParkInfo.o());
        jSONObject.put(StandardProtocolKey.NAME, protocolParkInfo.getName());
        jSONObject.put(StandardProtocolKey.POI_DISTANCE, protocolParkInfo.getDistance());
        jSONObject.put(StandardProtocolKey.POIDEEPINFO_TAGINFO_PRICE, protocolParkInfo.p());
        jSONObject.put("latitude", protocolParkInfo.getLatitude());
        jSONObject.put("longitude", protocolParkInfo.getLongitude());
        jSONObject.put(StandardProtocolKey.ENTRY_LONGITUDE, protocolParkInfo.getEntry_longitude());
        jSONObject.put(StandardProtocolKey.ENTRY_LATITUDE, protocolParkInfo.getEntry_latitude());
        jSONObject.put(StandardProtocolKey.POIDEEPINFO_CATEGORY, protocolParkInfo.n());
        jSONObject.put("spacenum", protocolParkInfo.q());
        jSONObject.put(StandardProtocolKey.POIID, protocolParkInfo.getPoiid());
        return jSONObject;
    }
}
