package com.autonavi.amapauto.protocol.model.item;

import com.autonavi.amapauto.protocol.constant.StandardProtocolKey;
import java.io.Serializable;
import org.json.JSONObject;

/* loaded from: classes.dex */
public final class ProtocolPoi_JsonLubeParser implements Serializable {
    public static ProtocolPoi parse(JSONObject jSONObject) {
        if (jSONObject == null) {
            return null;
        }
        ProtocolPoi protocolPoi = new ProtocolPoi();
        protocolPoi.setClientPackageName(jSONObject.optString("clientPackageName", protocolPoi.getClientPackageName()));
        protocolPoi.setPackageName(jSONObject.optString("packageName", protocolPoi.getPackageName()));
        protocolPoi.setCallbackId(jSONObject.optInt("callbackId", protocolPoi.getCallbackId()));
        protocolPoi.setTimeStamp(jSONObject.optLong("timeStamp", protocolPoi.getTimeStamp()));
        protocolPoi.setVar1(jSONObject.optString("var1", protocolPoi.getVar1()));
        protocolPoi.c(jSONObject.optString("version", protocolPoi.q()));
        protocolPoi.setPoiId(jSONObject.optString(StandardProtocolKey.POI_ID, protocolPoi.getPoiId()));
        protocolPoi.setPoiName(jSONObject.optString(StandardProtocolKey.EXTRA_POINAME, protocolPoi.getPoiName()));
        protocolPoi.setLongitude(jSONObject.optDouble("longitude", protocolPoi.getLongitude()));
        protocolPoi.setLatitude(jSONObject.optDouble("latitude", protocolPoi.getLatitude()));
        protocolPoi.setEntryLongitude(jSONObject.optDouble(StandardProtocolKey.EXTRA_ENTRYLONGITUDE, protocolPoi.getEntryLongitude()));
        protocolPoi.setEntryLatitude(jSONObject.optDouble(StandardProtocolKey.EXTRA_ENTRYLATITUDE, protocolPoi.getEntryLatitude()));
        protocolPoi.setJson(jSONObject.optString("json", protocolPoi.getJson()));
        protocolPoi.setAddress(jSONObject.optString(StandardProtocolKey.POI_ADDRESS, protocolPoi.getAddress()));
        protocolPoi.a(jSONObject.optString("nTypeCode", protocolPoi.o()));
        protocolPoi.c(jSONObject.optInt("midtype", protocolPoi.n()));
        protocolPoi.b(jSONObject.optString("poiTypeName", protocolPoi.p()));
        protocolPoi.setDistance(jSONObject.optInt(StandardProtocolKey.POI_DISTANCE, protocolPoi.getDistance()));
        return protocolPoi;
    }
}
