package com.autonavi.amapauto.protocol.model.item;

import com.autonavi.amapauto.protocol.constant.StandardProtocolKey;
import java.io.Serializable;
import org.json.JSONException;
import org.json.JSONObject;

/* loaded from: classes.dex */
public final class ProtocolPoi_JsonLubeSerializer implements Serializable {
    public static JSONObject serialize(ProtocolPoi protocolPoi) throws JSONException {
        if (protocolPoi == null) {
            return null;
        }
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("packageName", protocolPoi.getPackageName());
        jSONObject.put("clientPackageName", protocolPoi.getClientPackageName());
        jSONObject.put("callbackId", protocolPoi.getCallbackId());
        jSONObject.put("timeStamp", protocolPoi.getTimeStamp());
        jSONObject.put("var1", protocolPoi.getVar1());
        jSONObject.put("version", protocolPoi.q());
        jSONObject.put(StandardProtocolKey.POI_ID, protocolPoi.getPoiId());
        jSONObject.put(StandardProtocolKey.EXTRA_POINAME, protocolPoi.getPoiName());
        jSONObject.put("longitude", protocolPoi.getLongitude());
        jSONObject.put("latitude", protocolPoi.getLatitude());
        jSONObject.put(StandardProtocolKey.EXTRA_ENTRYLONGITUDE, protocolPoi.getEntryLongitude());
        jSONObject.put(StandardProtocolKey.EXTRA_ENTRYLATITUDE, protocolPoi.getEntryLatitude());
        jSONObject.put("json", protocolPoi.getJson());
        jSONObject.put(StandardProtocolKey.POI_ADDRESS, protocolPoi.getAddress());
        jSONObject.put("nTypeCode", protocolPoi.o());
        jSONObject.put("midtype", protocolPoi.n());
        jSONObject.put("poiTypeName", protocolPoi.p());
        jSONObject.put(StandardProtocolKey.POI_DISTANCE, protocolPoi.getDistance());
        return jSONObject;
    }
}
