package com.autonavi.amapauto.protocol.model.item;

import com.autonavi.amapauto.protocol.constant.StandardProtocolKey;
import java.io.Serializable;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONObject;

/* loaded from: classes.dex */
public final class ProtocolRouteInfo_JsonLubeParser implements Serializable {
    public static ProtocolRouteInfo parse(JSONObject jSONObject) {
        if (jSONObject == null) {
            return null;
        }
        ProtocolRouteInfo protocolRouteInfo = new ProtocolRouteInfo();
        protocolRouteInfo.q = jSONObject.optInt(StandardProtocolKey.ROUTEINFO_VIAPOITIME, protocolRouteInfo.q);
        protocolRouteInfo.r = jSONObject.optInt(StandardProtocolKey.ROUTEINFO_VIAPOIDISTANCE, protocolRouteInfo.r);
        protocolRouteInfo.setClientPackageName(jSONObject.optString("clientPackageName", protocolRouteInfo.getClientPackageName()));
        protocolRouteInfo.setPackageName(jSONObject.optString("packageName", protocolRouteInfo.getPackageName()));
        protocolRouteInfo.setCallbackId(jSONObject.optInt("callbackId", protocolRouteInfo.getCallbackId()));
        protocolRouteInfo.setTimeStamp(jSONObject.optLong("timeStamp", protocolRouteInfo.getTimeStamp()));
        protocolRouteInfo.setVar1(jSONObject.optString("var1", protocolRouteInfo.getVar1()));
        protocolRouteInfo.f(jSONObject.optString("version", protocolRouteInfo.A()));
        protocolRouteInfo.b(jSONObject.optString(StandardProtocolKey.METHOD, protocolRouteInfo.o()));
        protocolRouteInfo.d(jSONObject.optInt("routePreference", protocolRouteInfo.r()));
        protocolRouteInfo.b(jSONObject.optDouble(StandardProtocolKey.TIME, protocolRouteInfo.t()));
        protocolRouteInfo.a(jSONObject.optDouble(StandardProtocolKey.POI_DISTANCE, protocolRouteInfo.getDistance()));
        protocolRouteInfo.c(jSONObject.optString("timeAuto", protocolRouteInfo.u()));
        protocolRouteInfo.a(jSONObject.optString("distanceAuto", protocolRouteInfo.n()));
        protocolRouteInfo.g(jSONObject.optInt("trafficLights", protocolRouteInfo.z()));
        protocolRouteInfo.f(jSONObject.optInt("tolls", protocolRouteInfo.x()));
        protocolRouteInfo.setJson(jSONObject.optString("json", protocolRouteInfo.getJson()));
        protocolRouteInfo.e(jSONObject.optInt("tmcSize", protocolRouteInfo.w()));
        protocolRouteInfo.d(jSONObject.optString("tmcSegments", protocolRouteInfo.v()));
        protocolRouteInfo.h(jSONObject.optInt("viaCityNumbers", protocolRouteInfo.B()));
        JSONArray optJSONArray = jSONObject.optJSONArray("protocolCityInfos");
        if (optJSONArray != null) {
            int length = optJSONArray.length();
            ArrayList<ProtocolCityInfo> arrayList = new ArrayList<>(length);
            for (int i = 0; i < length; i++) {
                arrayList.add(ProtocolCityInfo_JsonLubeParser.parse(optJSONArray.optJSONObject(i)));
            }
            protocolRouteInfo.a(arrayList);
        }
        protocolRouteInfo.c(jSONObject.optInt(StandardProtocolKey.ODD_NUM, protocolRouteInfo.p()));
        protocolRouteInfo.e(jSONObject.optString(StandardProtocolKey.TOTAL_ODD_DISTANCE, protocolRouteInfo.y()));
        protocolRouteInfo.setNewStrategy(jSONObject.optInt("newStrategy", protocolRouteInfo.getNewStrategy()));
        JSONArray optJSONArray2 = jSONObject.optJSONArray(StandardProtocolKey.STREET_NAMES);
        if (optJSONArray2 != null) {
            int length2 = optJSONArray2.length();
            ArrayList<String> arrayList2 = new ArrayList<>(length2);
            for (int i2 = 0; i2 < length2; i2++) {
                arrayList2.add(optJSONArray2.optString(i2));
            }
            protocolRouteInfo.b(arrayList2);
        }
        return protocolRouteInfo;
    }
}
