package com.autonavi.amapauto.protocol.model.item;

import com.autonavi.amapauto.protocol.constant.StandardProtocolKey;
import java.io.Serializable;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/* loaded from: classes.dex */
public final class ProtocolRouteInfo_JsonLubeSerializer implements Serializable {
    public static JSONObject serialize(ProtocolRouteInfo protocolRouteInfo) throws JSONException {
        if (protocolRouteInfo == null) {
            return null;
        }
        JSONObject jSONObject = new JSONObject();
        jSONObject.put(StandardProtocolKey.ROUTEINFO_VIAPOITIME, protocolRouteInfo.q);
        jSONObject.put(StandardProtocolKey.ROUTEINFO_VIAPOIDISTANCE, protocolRouteInfo.r);
        jSONObject.put("packageName", protocolRouteInfo.getPackageName());
        jSONObject.put("clientPackageName", protocolRouteInfo.getClientPackageName());
        jSONObject.put("callbackId", protocolRouteInfo.getCallbackId());
        jSONObject.put("timeStamp", protocolRouteInfo.getTimeStamp());
        jSONObject.put("var1", protocolRouteInfo.getVar1());
        jSONObject.put("version", protocolRouteInfo.A());
        jSONObject.put(StandardProtocolKey.METHOD, protocolRouteInfo.o());
        jSONObject.put("routePreference", protocolRouteInfo.r());
        jSONObject.put(StandardProtocolKey.TIME, protocolRouteInfo.t());
        jSONObject.put(StandardProtocolKey.POI_DISTANCE, protocolRouteInfo.getDistance());
        jSONObject.put("timeAuto", protocolRouteInfo.u());
        jSONObject.put("distanceAuto", protocolRouteInfo.n());
        jSONObject.put("trafficLights", protocolRouteInfo.z());
        jSONObject.put("tolls", protocolRouteInfo.x());
        jSONObject.put("json", protocolRouteInfo.getJson());
        jSONObject.put("tmcSize", protocolRouteInfo.w());
        jSONObject.put("tmcSegments", protocolRouteInfo.v());
        jSONObject.put("viaCityNumbers", protocolRouteInfo.B());
        if (protocolRouteInfo.q() != null) {
            JSONArray jSONArray = new JSONArray();
            Iterator<ProtocolCityInfo> it = protocolRouteInfo.q().iterator();
            while (it.hasNext()) {
                ProtocolCityInfo next = it.next();
                if (next != null) {
                    jSONArray.put(ProtocolCityInfo_JsonLubeSerializer.serialize(next));
                }
            }
            jSONObject.put("protocolCityInfos", jSONArray);
        }
        jSONObject.put(StandardProtocolKey.ODD_NUM, protocolRouteInfo.p());
        jSONObject.put(StandardProtocolKey.TOTAL_ODD_DISTANCE, protocolRouteInfo.y());
        jSONObject.put("newStrategy", protocolRouteInfo.getNewStrategy());
        if (protocolRouteInfo.s() != null) {
            JSONArray jSONArray2 = new JSONArray();
            Iterator<String> it2 = protocolRouteInfo.s().iterator();
            while (it2.hasNext()) {
                jSONArray2.put(it2.next());
            }
            jSONObject.put(StandardProtocolKey.STREET_NAMES, jSONArray2);
        }
        return jSONObject;
    }
}
