package com.autonavi.amapauto.protocol.model.item;

import com.autonavi.amapauto.protocol.constant.StandardProtocolKey;
import java.io.Serializable;
import org.json.JSONObject;

/* loaded from: classes.dex */
public final class ProtocolViaPOIInfo_JsonLubeParser implements Serializable {
    public static ProtocolViaPOIInfo parse(JSONObject jSONObject) {
        if (jSONObject == null) {
            return null;
        }
        ProtocolViaPOIInfo protocolViaPOIInfo = new ProtocolViaPOIInfo();
        protocolViaPOIInfo.setClientPackageName(jSONObject.optString("clientPackageName", protocolViaPOIInfo.getClientPackageName()));
        protocolViaPOIInfo.setPackageName(jSONObject.optString("packageName", protocolViaPOIInfo.getPackageName()));
        protocolViaPOIInfo.setCallbackId(jSONObject.optInt("callbackId", protocolViaPOIInfo.getCallbackId()));
        protocolViaPOIInfo.setTimeStamp(jSONObject.optLong("timeStamp", protocolViaPOIInfo.getTimeStamp()));
        protocolViaPOIInfo.setVar1(jSONObject.optString("var1", protocolViaPOIInfo.getVar1()));
        protocolViaPOIInfo.b(jSONObject.optString("viaPOIName", protocolViaPOIInfo.t()));
        protocolViaPOIInfo.a(jSONObject.optString("viaPOIAddr", protocolViaPOIInfo.p()));
        protocolViaPOIInfo.d(jSONObject.optDouble("viaPOILongitude", protocolViaPOIInfo.s()));
        protocolViaPOIInfo.c(jSONObject.optDouble("viaPOILatitude", protocolViaPOIInfo.r()));
        protocolViaPOIInfo.setJson(jSONObject.optString("json", protocolViaPOIInfo.getJson()));
        protocolViaPOIInfo.d(jSONObject.optString("viaPOIType", protocolViaPOIInfo.v()));
        protocolViaPOIInfo.a(jSONObject.optDouble(StandardProtocolKey.MID_VIA_ENTRYLATITUDE, protocolViaPOIInfo.n()));
        protocolViaPOIInfo.b(jSONObject.optDouble(StandardProtocolKey.MID_VIA_ENTRYLONGITUDE, protocolViaPOIInfo.o()));
        protocolViaPOIInfo.e(jSONObject.optString(StandardProtocolKey.MID_VIA_POIID, protocolViaPOIInfo.w()));
        protocolViaPOIInfo.c(jSONObject.optInt("viaPOIDistance", protocolViaPOIInfo.q()));
        protocolViaPOIInfo.c(jSONObject.optString("viaPOIPhone", protocolViaPOIInfo.u()));
        return protocolViaPOIInfo;
    }
}
