package com.autonavi.amapauto.protocol.model.item;

import com.autonavi.amapauto.protocol.constant.StandardProtocolKey;
import java.io.Serializable;
import org.json.JSONException;
import org.json.JSONObject;

/* loaded from: classes.dex */
public final class ProtocolViaPOIInfo_JsonLubeSerializer implements Serializable {
    public static JSONObject serialize(ProtocolViaPOIInfo protocolViaPOIInfo) throws JSONException {
        if (protocolViaPOIInfo == null) {
            return null;
        }
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("packageName", protocolViaPOIInfo.getPackageName());
        jSONObject.put("clientPackageName", protocolViaPOIInfo.getClientPackageName());
        jSONObject.put("callbackId", protocolViaPOIInfo.getCallbackId());
        jSONObject.put("timeStamp", protocolViaPOIInfo.getTimeStamp());
        jSONObject.put("var1", protocolViaPOIInfo.getVar1());
        jSONObject.put("viaPOIName", protocolViaPOIInfo.t());
        jSONObject.put("viaPOIAddr", protocolViaPOIInfo.p());
        jSONObject.put("viaPOILongitude", protocolViaPOIInfo.s());
        jSONObject.put("viaPOILatitude", protocolViaPOIInfo.r());
        jSONObject.put("json", protocolViaPOIInfo.getJson());
        jSONObject.put("viaPOIType", protocolViaPOIInfo.v());
        jSONObject.put(StandardProtocolKey.MID_VIA_ENTRYLATITUDE, protocolViaPOIInfo.n());
        jSONObject.put(StandardProtocolKey.MID_VIA_ENTRYLONGITUDE, protocolViaPOIInfo.o());
        jSONObject.put(StandardProtocolKey.MID_VIA_POIID, protocolViaPOIInfo.w());
        jSONObject.put("viaPOIDistance", protocolViaPOIInfo.q());
        jSONObject.put("viaPOIPhone", protocolViaPOIInfo.u());
        return jSONObject;
    }
}
