package com.autonavi.amapauto.protocol.model.item;

import com.autonavi.amapauto.protocol.constant.StandardProtocolKey;
import java.io.Serializable;
import org.json.JSONObject;

/* loaded from: classes.dex */
public final class Route_JsonLubeParser implements Serializable {
    public static Route parse(JSONObject jSONObject) {
        if (jSONObject == null) {
            return null;
        }
        Route route = new Route();
        route.setClientPackageName(jSONObject.optString("clientPackageName", route.getClientPackageName()));
        route.setPackageName(jSONObject.optString("packageName", route.getPackageName()));
        route.setCallbackId(jSONObject.optInt("callbackId", route.getCallbackId()));
        route.setTimeStamp(jSONObject.optLong("timeStamp", route.getTimeStamp()));
        route.setVar1(jSONObject.optString("var1", route.getVar1()));
        route.c(jSONObject.optInt("cost", route.n()));
        route.setDistance(jSONObject.optInt(StandardProtocolKey.POI_DISTANCE, route.getDistance()));
        route.a(jSONObject.optString("label", route.o()));
        route.setNum(jSONObject.optLong(StandardProtocolKey.EXTRA_NUM, route.getNum()));
        route.d(jSONObject.optInt(StandardProtocolKey.TIME, route.p()));
        route.e(jSONObject.optInt("trafficLight", route.q()));
        route.setType(jSONObject.optInt("type", route.getType()));
        return route;
    }
}
