package com.autonavi.amapauto.protocol.model.item;

import com.autonavi.amapauto.protocol.constant.StandardProtocolKey;
import java.io.Serializable;
import org.json.JSONException;
import org.json.JSONObject;

/* loaded from: classes.dex */
public final class Route_JsonLubeSerializer implements Serializable {
    public static JSONObject serialize(Route route) throws JSONException {
        if (route == null) {
            return null;
        }
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("packageName", route.getPackageName());
        jSONObject.put("clientPackageName", route.getClientPackageName());
        jSONObject.put("callbackId", route.getCallbackId());
        jSONObject.put("timeStamp", route.getTimeStamp());
        jSONObject.put("var1", route.getVar1());
        jSONObject.put("cost", route.n());
        jSONObject.put(StandardProtocolKey.POI_DISTANCE, route.getDistance());
        jSONObject.put("label", route.o());
        jSONObject.put(StandardProtocolKey.EXTRA_NUM, route.getNum());
        jSONObject.put(StandardProtocolKey.TIME, route.p());
        jSONObject.put("trafficLight", route.q());
        jSONObject.put("type", route.getType());
        return jSONObject;
    }
}
