package com.autonavi.amapauto.protocol.model.item;

import com.autonavi.amapauto.protocol.constant.StandardProtocolKey;
import java.io.Serializable;
import org.json.JSONObject;

/* loaded from: classes.dex */
public final class TrafficLaneInfo_JsonLubeParser implements Serializable {
    public static TrafficLaneInfo parse(JSONObject jSONObject) {
        if (jSONObject == null) {
            return null;
        }
        TrafficLaneInfo trafficLaneInfo = new TrafficLaneInfo();
        trafficLaneInfo.setClientPackageName(jSONObject.optString("clientPackageName", trafficLaneInfo.getClientPackageName()));
        trafficLaneInfo.setPackageName(jSONObject.optString("packageName", trafficLaneInfo.getPackageName()));
        trafficLaneInfo.setCallbackId(jSONObject.optInt("callbackId", trafficLaneInfo.getCallbackId()));
        trafficLaneInfo.setTimeStamp(jSONObject.optLong("timeStamp", trafficLaneInfo.getTimeStamp()));
        trafficLaneInfo.setVar1(jSONObject.optString("var1", trafficLaneInfo.getVar1()));
        trafficLaneInfo.a(jSONObject.optString("version", trafficLaneInfo.t()));
        trafficLaneInfo.f(jSONObject.optInt("trafficLaneNo", trafficLaneInfo.r()));
        trafficLaneInfo.e(jSONObject.optInt("trafficLaneIcon", trafficLaneInfo.q()));
        trafficLaneInfo.c(jSONObject.optInt("trafficLaneExtended", trafficLaneInfo.o()));
        trafficLaneInfo.a(jSONObject.optBoolean(StandardProtocolKey.KEY_TRAFFIC_LANE_ADVISED, trafficLaneInfo.n()));
        trafficLaneInfo.d(jSONObject.optInt(StandardProtocolKey.KEY_TRAFFIC_LANE_EXTENDEDNEW, trafficLaneInfo.p()));
        trafficLaneInfo.g(jSONObject.optInt(StandardProtocolKey.KEY_TRAFFIC_LANE_TYPE, trafficLaneInfo.s()));
        return trafficLaneInfo;
    }
}
