package com.autonavi.amapauto.protocol.model.item;

import com.autonavi.amapauto.protocol.constant.StandardProtocolKey;
import java.io.Serializable;
import org.json.JSONException;
import org.json.JSONObject;

/* loaded from: classes.dex */
public final class TrafficLaneInfo_JsonLubeSerializer implements Serializable {
    public static JSONObject serialize(TrafficLaneInfo trafficLaneInfo) throws JSONException {
        if (trafficLaneInfo == null) {
            return null;
        }
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("packageName", trafficLaneInfo.getPackageName());
        jSONObject.put("clientPackageName", trafficLaneInfo.getClientPackageName());
        jSONObject.put("callbackId", trafficLaneInfo.getCallbackId());
        jSONObject.put("timeStamp", trafficLaneInfo.getTimeStamp());
        jSONObject.put("var1", trafficLaneInfo.getVar1());
        jSONObject.put("version", trafficLaneInfo.t());
        jSONObject.put("trafficLaneNo", trafficLaneInfo.r());
        jSONObject.put("trafficLaneIcon", trafficLaneInfo.q());
        jSONObject.put("trafficLaneExtended", trafficLaneInfo.o());
        jSONObject.put(StandardProtocolKey.KEY_TRAFFIC_LANE_ADVISED, trafficLaneInfo.n());
        jSONObject.put(StandardProtocolKey.KEY_TRAFFIC_LANE_EXTENDEDNEW, trafficLaneInfo.p());
        jSONObject.put(StandardProtocolKey.KEY_TRAFFIC_LANE_TYPE, trafficLaneInfo.s());
        return jSONObject;
    }
}
