package com.autonavi.amapauto.protocol.model.service;

import com.amap.location.sdk.fusion.LocationParams;
import com.taobao.wireless.security.sdk.indiekit.IndieKitDefine;
import java.io.Serializable;
import org.json.JSONException;
import org.json.JSONObject;

/* loaded from: classes.dex */
public final class DrLocationInfoModel_JsonLubeSerializer implements Serializable {
    public static JSONObject serialize(DrLocationInfoModel drLocationInfoModel) throws JSONException {
        if (drLocationInfoModel == null) {
            return null;
        }
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("packageName", drLocationInfoModel.getPackageName());
        jSONObject.put("clientPackageName", drLocationInfoModel.getClientPackageName());
        jSONObject.put("callbackId", drLocationInfoModel.getCallbackId());
        jSONObject.put("timeStamp", drLocationInfoModel.getTimeStamp());
        jSONObject.put("var1", drLocationInfoModel.getVar1());
        jSONObject.put("gpgga", drLocationInfoModel.q());
        jSONObject.put("gprmc", drLocationInfoModel.u());
        jSONObject.put("gpgsv", drLocationInfoModel.t());
        jSONObject.put("gpgsa", drLocationInfoModel.s());
        jSONObject.put("gpvtg", drLocationInfoModel.v());
        jSONObject.put("gpgll", drLocationInfoModel.r());
        jSONObject.put(IndieKitDefine.SG_KEY_INDIE_KIT_TIMESTAMP, drLocationInfoModel.A());
        jSONObject.put(LocationParams.PARA_FLP_AUTONAVI_LAT, drLocationInfoModel.getLat());
        jSONObject.put("ns", drLocationInfoModel.y());
        jSONObject.put(LocationParams.PARA_FLP_AUTONAVI_LON, drLocationInfoModel.getLon());
        jSONObject.put("ew", drLocationInfoModel.p());
        jSONObject.put("course", drLocationInfoModel.n());
        jSONObject.put("posAcc", drLocationInfoModel.z());
        jSONObject.put("drStatus", drLocationInfoModel.o());
        jSONObject.put("matchLon", drLocationInfoModel.x());
        jSONObject.put("matchLat", drLocationInfoModel.w());
        return jSONObject;
    }
}
