package com.autonavi.amapauto.protocol.model.service;

import com.autonavi.amapauto.protocol.model.item.TrafficLaneInfo;
import com.autonavi.amapauto.protocol.model.item.TrafficLaneInfo_JsonLubeParser;
import java.io.Serializable;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONObject;

/* loaded from: classes.dex */
public final class DriveWayProtocolSdkModel_JsonLubeParser implements Serializable {
    public static DriveWayProtocolSdkModel parse(JSONObject jSONObject) {
        if (jSONObject == null) {
            return null;
        }
        DriveWayProtocolSdkModel driveWayProtocolSdkModel = new DriveWayProtocolSdkModel();
        driveWayProtocolSdkModel.setClientPackageName(jSONObject.optString("clientPackageName", driveWayProtocolSdkModel.getClientPackageName()));
        driveWayProtocolSdkModel.setPackageName(jSONObject.optString("packageName", driveWayProtocolSdkModel.getPackageName()));
        driveWayProtocolSdkModel.setCallbackId(jSONObject.optInt("callbackId", driveWayProtocolSdkModel.getCallbackId()));
        driveWayProtocolSdkModel.setTimeStamp(jSONObject.optLong("timeStamp", driveWayProtocolSdkModel.getTimeStamp()));
        driveWayProtocolSdkModel.setVar1(jSONObject.optString("var1", driveWayProtocolSdkModel.getVar1()));
        driveWayProtocolSdkModel.a(jSONObject.optBoolean("trafficLaneEnabled", driveWayProtocolSdkModel.p()));
        driveWayProtocolSdkModel.c(jSONObject.optInt("trafficLaneSize", driveWayProtocolSdkModel.o()));
        JSONArray optJSONArray = jSONObject.optJSONArray("trafficLaneInfos");
        if (optJSONArray != null) {
            int length = optJSONArray.length();
            ArrayList<TrafficLaneInfo> arrayList = new ArrayList<>(length);
            for (int i = 0; i < length; i++) {
                arrayList.add(TrafficLaneInfo_JsonLubeParser.parse(optJSONArray.optJSONObject(i)));
            }
            driveWayProtocolSdkModel.a(arrayList);
        }
        return driveWayProtocolSdkModel;
    }
}
